package gov.va.cpss.job.cbs;

/**
 * Constants used by Generate CBS batch job to dynamically update the job
 * execution context during batch operations.
 * 
 * @author DNS  
 */
public final class CbsProcessingConstants {

	/**
	 * The key to populate with running count of the number of generated
	 * statements in INITIAL state.
	 */
	public static final String CBS_TOTAL_INITIAL_STATEMENT_COUNT_KEY = "totalCBSInitialCount";

	/**
	 * The key to populate with running count of the number of updated
	 * statements in REPLACED state.
	 */
	public static final String CBS_TOTAL_REPLACED_STATEMENT_COUNT_KEY = "totalCBSReplacedCount";

	/**
	 * The key to populate with the number of available statements in NEW state.
	 */
	public static final String CBS_AVAILABLE_STATISTICS_KEY = "totalCBSAvailable";

	/**
	 * The label for the number of available statistics.
	 */
	public static final String CBS_AVAILABLE_STATISTICS_LABEL = "Total CBS Available: ";

	/**
	 * The key to populate with the number of generated statements in NEW state.
	 */
	public static final String CBS_GENERATED_STATISTICS_KEY = "totalCBSGenerated";

	/**
	 * The label for the number of generated statistics.
	 */
	public static final String CBS_GENERATED_STATISTICS_LABEL = "Total CBS Generated: ";

	/**
	 * The key to populate with the list of detected patient errors.
	 */
	public static final String CBS_DETECTED_PATIENTS_ERROR_KEY = "detectedPatientErrors";

}
