package gov.va.cpss.job.caps;

import java.util.List;
import java.util.Map;

import org.springframework.util.ClassUtils;

import gov.va.cpss.job.CBSSPagingItemReader;

import gov.va.cpss.model.apps.APSPatient;

import gov.va.cpss.service.GenerateAPPSService;
import gov.va.cpss.service.Result;

/**
 * 
 * This is a paging item reader for CAPS.
 * 
 * Copyright HPE / VA
 * January 25, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
@SuppressWarnings("nls")
public class CAPSPagingItemReader extends CBSSPagingItemReader<APSPatient>
{
    // Injected property
    private GenerateAPPSService generateAPPSService;


    // Constructor
    public CAPSPagingItemReader()
    {
        setName(ClassUtils.getShortName(CAPSPagingItemReader.class));
    }

    public GenerateAPPSService getGenerateAPPSService()
    {
        return this.generateAPPSService;
    }

    public void setGenerateAPPSService(GenerateAPPSService inGenerateAPPSService)
    {
        this.generateAPPSService = inGenerateAPPSService;
    }


    @Override
    protected List<APSPatient> executePageRead(int page, int pageSize, Map<String, Object> inParameterValues)
    {
        this.logger.debug("Before Execute Page Read.");

        // Get the starting time
        final long startTime = System.nanoTime();

        // Read NEW APSPatient data in pages
        Result<List<APSPatient>> result = this.generateAPPSService.getNewPatientsWithPaging(page, pageSize);

        if (!result.isSuccessful())
        {
            this.logger.error("Failed to read: " + result.getMessage());
            return null;
        }

        final long elapsedTime = System.nanoTime() - startTime;

        this.logger.debug("End Execute Page Read. " + this.generateAPPSService.printElapsedTime("method", elapsedTime));

        return result.get();
    }
}
