package gov.va.cpss.job.appsprintack;

import static gov.va.cpss.job.CbssJobProcessingConstants.DATA_ERROR_STATUS;

import java.util.List;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.scope.context.ChunkContext;

import gov.va.cpss.job.CbssJobBaseTransactionTasklet;
import gov.va.cpss.job.UpdateAPPSPrintAckJob;
import gov.va.cpss.service.Result;
import gov.va.cpss.service.UpdateAPPSPrintAckService;

public class UpdateAppsPrintAckUndoAcksCompletionTasklet extends CbssJobBaseTransactionTasklet {

	private UpdateAPPSPrintAckService updateAppsPrintAckService;

	public UpdateAPPSPrintAckService getUpdatePrintAckService() {
		return updateAppsPrintAckService;
	}

	public void setUpdateAppsPrintAckService(UpdateAPPSPrintAckService updateAppsPrintAckService) {
		this.updateAppsPrintAckService = updateAppsPrintAckService;
	}

	@Override
	protected boolean executeLogic(ChunkContext chunkContext) {
		boolean successful = true;

		taskletLogger.info("Undo Print Acknowledgements Tasklet Running!");
		
		final JobExecution jobExecution = chunkContext.getStepContext().getStepExecution().getJobExecution();
		
		final List<Long> batchRunProcessIdList = UpdateAPPSPrintAckJob.getCurrentFileAppsBatchRunProcessIdList(jobExecution);

		final Result<Object[]> result = updateAppsPrintAckService.undoPrintAcknowledgements(batchRunProcessIdList);
		
		if (! result.isSuccessful()) {
			// If the undo fails, then exit with error.
			setFailureStatus(jobExecution, DATA_ERROR_STATUS, "Rollback Triggered: " + result.getMessage());
			
			successful = false;
		}

		return successful;
	}
}
