package gov.va.cpss.job.apps;

import java.util.List;
import java.util.Map.Entry;

import org.springframework.batch.item.ItemWriter;
import org.springframework.classify.Classifier;

import gov.va.cpss.model.apps.APSSite;

/**
 *
 * A classifier that will return a specific writer depending on input data:
 * For (error) messages, return MessageWriter;
 * For data, return DataWriter.
 * 
 * Copyright DXC / VA
 * April 13, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
public class APPSWriterClassifier implements Classifier<Entry<APSSite, ? extends List<?>>, ItemWriter<Entry<APSSite, ? extends List<?>>>>
{
    // Injected properties
    private ItemWriter<Entry<APSSite, ? extends List<?>>> messageWriter;
    private ItemWriter<Entry<APSSite, ? extends List<?>>> dataWriter;

    /**
     * @param inMessageWriter the messageWriter to set
     */
    public void setMessageWriter(ItemWriter<Entry<APSSite, ? extends List<?>>> inMessageWriter)
    {
        this.messageWriter = inMessageWriter;
    }

    /**
     * @param inDataWriter the dataWriter to set
     */
    public void setDataWriter(ItemWriter<Entry<APSSite, ? extends List<?>>> inDataWriter)
    {
        this.dataWriter = inDataWriter;
    }

    @Override
    public ItemWriter<Entry<APSSite, ? extends List<?>>> classify(Entry<APSSite, ? extends List<?>> entry)
    {
        if ( entry == null ||
             entry.getValue() == null ||
             entry.getValue().isEmpty() ||
             entry.getValue().get(0) instanceof String )
        {
            return this.messageWriter;
        }

        return this.dataWriter;
    }
}
