package gov.va.cpss.job.apps;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import java.util.concurrent.BlockingQueue;

import gov.va.cpss.job.CbssStreamToQueueThread;

/**
 * 
 * Implementation of CbssStreamToQueueThread used to handle reading of raw records
 * when loading and processing APPS data.
 * 
 * Copyright HPE / VA
 * November 2, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
@SuppressWarnings("nls")
public class APPSStreamToQueueThread extends CbssStreamToQueueThread
{
	/**
	 * Constructor for thread to process the provided input stream in to an
	 * output queue for each record as indicated by a line feed. The expected
	 * bytes is provided for verification check the data was successfully
	 * processed.
	 * 
	 * @param inExpectedByteCount
	 *            The expected amount of bytes to read.
	 * @param inputStream
	 *            The input stream.
	 * @param inOutputQueue
	 *            The output queue.
	 * @throws UnsupportedEncodingException
	 */
	public APPSStreamToQueueThread(long inExpectedByteCount,
	                               InputStream inputStream,
	                               BlockingQueue<String> inOutputQueue)
	       throws UnsupportedEncodingException
	{
		super(inExpectedByteCount, inputStream, inOutputQueue);
	}
	
	@Override
	public boolean populateQueue()
	{
		boolean isSuccessful = false;

		try
		{
			String line = this.bufferedReader.readLine();
			
			// Loop until thread is interrupted or no more lines available.
			while (!isInterrupted() && (line != null))
			{
				if (!line.isEmpty())
				{
					//Split the line based on the pipe delimiter or tilde
					//String[] recordArray = line.split("[|~]");
				    // Split the line based on the close curly bracket or tilde.
                    String[] recordArray = line.split("[}~]");

					for(int i = 0; i < recordArray.length; i++)
					{
						//logger.debug("SAVING INTO Q: |" + recordArray[i] + "|");
						this.outputQueue.put(recordArray[i]);
					}
				}

				line = this.bufferedReader.readLine();
				logger.debug("APPSStreamToQueueThread.populateQueue() - Line read: " + line);
			}
			
			isSuccessful = true;
		}
		catch (IOException | InterruptedException e)
		{
			logger.error("Exception occurred during processing file stream into queue: " + e.getMessage());
		}
		finally
		{
			try
			{
				this.bufferedReader.close();
				isSuccessful = true;
			}
			catch (IOException e)
			{
				logger.error("Exception occurred when attempting to close reader: " + e.getMessage());
			}
		}

		return isSuccessful;
	}
}
