package gov.va.cpss.job.apps;

import java.util.List;
import java.util.Map.Entry;

import org.springframework.batch.item.ItemProcessor;
import org.springframework.classify.Classifier;

import gov.va.cpss.model.apps.APPSCompositeData;
import gov.va.cpss.model.apps.APSSite;

/**
 *
 * A classifier that will return a specific processor depending on input data:
 * For (error) messages, return MessageProcessor;
 * For data, return DataProcessor.
 * 
 * Copyright DXC / VA
 * April 12, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
public class APPSProcessorClassifier implements Classifier<APPSCompositeData, ItemProcessor<APPSCompositeData, Entry<APSSite, ? extends List<?>>>>
{
    // Injected properties
    private ItemProcessor<APPSCompositeData, Entry<APSSite, ? extends List<?>>> messageProcessor;
    private ItemProcessor<APPSCompositeData, Entry<APSSite, ? extends List<?>>> dataProcessor;

    /**
     * @param inMessageProcessor the messageProcessor to set
     */
    public void setMessageProcessor(ItemProcessor<APPSCompositeData, Entry<APSSite, ? extends List<?>>> inMessageProcessor)
    {
        this.messageProcessor = inMessageProcessor;
    }

    /**
     * @param inDataProcessor the dataProcessor to set
     */
    public void setDataProcessor(ItemProcessor<APPSCompositeData, Entry<APSSite, ? extends List<?>>> inDataProcessor)
    {
        this.dataProcessor = inDataProcessor;
    }

    @Override
    public ItemProcessor<APPSCompositeData, Entry<APSSite, ? extends List<?>>> classify(APPSCompositeData compositeData)
    {
        if (compositeData == null ||
            !compositeData.isValid() ||
            compositeData.getMessageEntry() != null)
        {
            return this.messageProcessor;
        }

        return this.dataProcessor;
    }

}
