package gov.va.cpss.job.apps;

import java.util.List;
import java.util.Map.Entry;

import gov.va.cpss.model.apps.APSSite;

import gov.va.cpss.job.CBSSFlatFileItemWriter;

/**
 * 
 * Implementation of FlatFileItemWriter used to handle writing of (error) messages to a file
 * when loading and processing APPS data and encountering errors.
 * 
 * Copyright DXC / VA
 * April 13, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
@SuppressWarnings("nls")
public class APPSMessageItemWriter extends CBSSFlatFileItemWriter<Entry<APSSite, List<String>>>
{
    @Override
    public void write(List<? extends Entry<APSSite, List<String>>> entries) throws Exception
    {
        logger.debug("Begin Write Message ...");

        // Do not attempt to write if forced stop or empty entries.
        if (this.isForceStop || entries == null || entries.isEmpty())
        {
            logger.debug("End Write Message - No message to write.");
            return;
        }

        //
        // Write (error) messages to file
        //
        super.write(entries);

        logger.debug("End Write Message.");
    }
}
