package gov.va.cpss.job.apps;

import static gov.va.cpss.model.ps.Constants.LINE_FEED;
import static gov.va.cpss.model.ps.Constants.FIELD_DELIMITER;
import static gov.va.cpss.model.ps.Constants.EMPTY_STRING;

import java.util.List;
import java.util.Map.Entry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.springframework.batch.item.file.transform.LineAggregator;

import gov.va.cpss.model.apps.APSSite;

/**
 * 
 * The APPS implementation of LineAggregator that transforms messages to string.
 * 
 * Copyright DXC / VA
 * April 21, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
@SuppressWarnings("nls")
public class APPSLineAggregator implements LineAggregator<Entry<APSSite, List<String>>>
{
    protected static final Log logger = LogFactory.getLog(APPSLineAggregator.class);

    @Override
    public String aggregate(Entry<APSSite, List<String>> entry)
    {
        if (entry == null)
        {   
            return null;
        }

        StringBuilder lines = new StringBuilder();

        String site = buildSite(entry.getKey());

        List<String> messages = entry.getValue();

        for (String message : messages)
        {
            lines.append(site);
            lines.append(" - ");
            lines.append(message);
            lines.append(LINE_FEED);
        }

        logger.debug("Messages: " + LINE_FEED + lines);

        return lines.toString();
    }

    private static String buildSite(APSSite site)
    {
        if (site == null)
        {
            return EMPTY_STRING;
        }

        StringBuilder siteLine = new StringBuilder();

        siteLine.append("PS");
        siteLine.append(FIELD_DELIMITER);
        siteLine.append(site.getSeqNumStr());
        siteLine.append(FIELD_DELIMITER);
        siteLine.append(site.getTotSeqNumStr());
        siteLine.append(FIELD_DELIMITER);
        siteLine.append(site.getFacilityNum());
        siteLine.append(FIELD_DELIMITER);
        siteLine.append(site.getFacilityPhoneNum());
        siteLine.append(FIELD_DELIMITER);
        siteLine.append(site.getTotalPatientStr());
        siteLine.append(FIELD_DELIMITER);
        siteLine.append(site.getStatementDateStr());
        siteLine.append(FIELD_DELIMITER);
        siteLine.append(site.getProcessDateStr());
 
        return siteLine.toString();
    }
}
