package gov.va.cpss.job;

import static gov.va.cpss.job.CbssJobProcessingConstants.BATCH_RUN_ID_KEY;
import static gov.va.cpss.job.sendbill.SendBillDataProcessingConstants.SEND_BILL_ID_KEY;
import static gov.va.cpss.job.sendbill.SendBillDataProcessingConstants.SEND_BILL_OUTPUT_FILE_NAME_KEY;
import static gov.va.cpss.job.sendbill.SendBillDataProcessingConstants.TOTAL_BILL_PATIENT_DATA_PROCESSED;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.job.flow.FlowJob;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.cpss.model.BatchRun;
import gov.va.cpss.model.bal.PatAcntBalMsg;
import gov.va.cpss.service.SendBillDataService;

public class SendBillDataJob extends CbssBaseJob {
	
	@Autowired
	private FlowJob SendBillDataJobBatch;
	
	@Autowired
	public SendBillDataService sendBillDataService;

	@Override
	protected FlowJob getJob() {
		return SendBillDataJobBatch;
	}
	
	@Override
	protected boolean runJob(final BatchRun batchRun, FlowJob job) {
		boolean successful = false;

		try {

			PatAcntBalMsg patMessage = sendBillDataService.startIsolatedSendBillJob(batchRun);

			JobParameters parameters = getParameters(patMessage);
			JobExecution execution = executeJob(job, parameters);
			successful = true;


			if (successful) {
				String totalPatientsIndluded = "UNKNOWN";
				if (execution.getExecutionContext().containsKey(TOTAL_BILL_PATIENT_DATA_PROCESSED)) {
					totalPatientsIndluded = ""
							+ execution.getExecutionContext().getLong(TOTAL_BILL_PATIENT_DATA_PROCESSED);
				} else {
					jobLogger.error("Unable to obtain key from process results: " + TOTAL_BILL_PATIENT_DATA_PROCESSED);
				}
				 buildInfoMessage(totalPatientsIndluded);
			}
		} catch (Exception e) {
			e.printStackTrace();
			super.appendErrorMessage(e.getMessage());
			
			successful = false;
		}

		return successful;
	}

	/**
	 * Build parameters for the batch job based on the PSReceived object.
	 * 
	 * @param pR
	 *            The PSReceived object representing the database entry.
	 * @return JobParameters object for this batch job run.
	 */
	protected JobParameters getParameters(PatAcntBalMsg patAcntBalMsg) {

		// Build job parameters for the input filename, received primary key id,
		// and the created or modified by string.
		return new JobParametersBuilder().addLong(SEND_BILL_ID_KEY, new Long(patAcntBalMsg.getId()))
				.addString(SEND_BILL_OUTPUT_FILE_NAME_KEY, patAcntBalMsg.getFileName()).addLong(BATCH_RUN_ID_KEY, new Long(patAcntBalMsg.getBatchRunId())).toJobParameters();
	}

	// /**
	// * Build this job specific informational message.
	// */
	 private void buildInfoMessage(String totalPatientsIndluded) {
	 StringBuffer strBuff = new StringBuffer();
	
	 strBuff.append("\n");
	 strBuff.append("Total Patients Included:").append(totalPatientsIndluded).append("\n");
	 
	
	 appendInfoMessage(strBuff.toString());
	 }
}
