package gov.va.cpss.job;

import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.scope.context.StepContext;

import gov.va.cpss.performance.PerformanceAnalyzer;

public class PerformanceAnalyzerChunkListener implements ChunkListener {

	private PerformanceAnalyzer memoryAnalyzer;
	
	public PerformanceAnalyzer getMemoryAnalyzer() {
		return memoryAnalyzer;
	}

	public void setMemoryAnalyzer(PerformanceAnalyzer memoryAnalyzer) {
		this.memoryAnalyzer = memoryAnalyzer;
	}

	@Override
	public void beforeChunk(ChunkContext context) {
		memoryAnalyzer.report(getAnalyzerMessage(context, "Before Chunk"));
	}

	@Override
	public void afterChunk(ChunkContext context) {
		memoryAnalyzer.report(getAnalyzerMessage(context, "After Chunk"));
	}

	@Override
	public void afterChunkError(ChunkContext context) {
		memoryAnalyzer.report(getAnalyzerMessage(context, "AfterError Chunk"));
	}
	
	private static String getAnalyzerMessage(ChunkContext context, String executionPoint) {
		final StringBuilder s = new StringBuilder();

		final StepContext stepContext = context.getStepContext();
		
		String jobName = null;
		String stepName = null;
		
		if (stepContext != null) {
			jobName = stepContext.getJobName();
			stepName = stepContext.getStepName();
		}
		
		s.append("Job:").append(jobName == null ? "unknown" : jobName);
		s.append(", Step:").append(stepName == null ? "unknown" : stepName);
		s.append("  ").append(executionPoint);

		return s.toString();
	}

}
