package gov.va.cpss.job;

import java.util.ArrayList;
import java.util.List;

import gov.va.cpss.model.BatchItem;
import gov.va.cpss.model.BatchJob;
import gov.va.cpss.model.BatchSrcType;
import gov.va.cpss.model.BatchStatus;
import gov.va.cpss.service.BatchService;

/**
 * Report if okay to proceed processing by checking if the sibling job is not
 * currently running.
 * 
 * @author DNS   
 */
public class CbssVerifySiblingJobNotRunningTasklet extends CbssBaseRetryTasklet {

	private List<String> jobNameList = new ArrayList<>();
	//Source Type is used determine between batch Types 1 is for CBSS Jobs
	private static int sourceType; 
	private BatchService batchService;

	public void setJobName(String jobName) {
		jobNameList.add(jobName);
	}
	
	public void setJobNameList(List<String> jobNameList) {
		this.jobNameList = jobNameList;
	}

	public BatchService getBatchService() {
		return batchService;
	}

	public void setBatchService(BatchService batchService) {
		this.batchService = batchService;
	}

	@Override
	protected boolean executeLogic() {
		
		boolean noSiblingsRunning = true;
		
		sourceType = batchService.getBatchSrcTypeId(BatchSrcType.SrcType.CBS);
		
		for (String jobName : jobNameList) {

			// Get the batch job.
			final BatchJob job = batchService.getBatchJobByNameAndSourceType(jobName, sourceType);
	
			if (job != null) {
	
				// Get most recent batch item.
				final BatchItem jobBatchItem = batchService.getBatchItemForJob(job);
	
				// Return true if no record of a run (null) or if not running.
				if (jobBatchItem.getRun() == null) {
					continue;
				} else if (jobBatchItem.getRun().getBatchStatus().getJobStatus() == BatchStatus.JobStatus.RUNNING) {
					taskletLogger.info("Job " + jobName + " is running");
					noSiblingsRunning = false;
					break;
				}
			} else {
	
				taskletLogger.error("Job " + jobName + " not found; check configuration");
				noSiblingsRunning = false;
				break;
			}
		}

		return noSiblingsRunning;
	}

}
