package gov.va.cpss.job;

/**
 * Constants generic to job processing used by batch jobs to dynamically update
 * the job execution context during batch operations.
 * 
 * @author DNS   
 */
@SuppressWarnings("nls")
public final class CbssJobProcessingConstants
{
	/**
	 * The key to identify the database primary key value for the batch run
	 * table entry associated with the job run.
	 */
	public static final String BATCH_RUN_ID_KEY = "batchRunId";

	/**
	 * The key to identify the time-stamp for the batch run
	 */
	public static final String BATCH_RUN_TIMESTAMP_KEY = "BatchRunTimestamp";

	/**
	 * The key to identify the custom batch job error exit status. Such an error
	 * allows the job to continue.
	 */
	public static final String JOB_ERROR_KEY = "JobError";

	/**
	 * The key to identify the custom batch job error message that correlates to
	 * the job error exit status. Such an error allows the job to continue.
	 */
	public static final String JOB_ERROR_MESSAGE_KEY = "JobErrorMessage";

	/**
	 * The key to identify the custom batch job failure exit status. Such an
	 * error causes the job to fail.
	 */
	public static final String JOB_FAILURE_KEY = "JobFailure";

	/**
	 * The key to identify the custom batch job failure message that correlates
	 * to the job failure exit status. Such an error causes the job to fail.
	 */
	public static final String JOB_FAILURE_MESSAGE_KEY = "JobFailureMessage";

	/**
	 * General File Open Failure Job Exit Status.
	 */
	public static final String FILE_OPEN_ERROR_STATUS = "FAILURE DURING FILE OPEN";

	/**
	 * General FTP Open Failure Job Exit Status.
	 */
	public static final String FTP_OPEN_ERROR_STATUS = "FAILURE DURING FTP OPEN CONNECTION";

	/**
	 * General Memory Open Failure Job Exit Status.
	 */
	public static final String MEMORY_OPEN_ERROR_STATUS = "FAILURE DURING OPEN MEMORY MAP";

	/**
	 * General Read Failure Job Exit Status.
	 */
	public static final String READ_FAILURE_STATUS = "FAILURE DURING READ";

	/**
	 * General Processing Failure Job Exit Status.
	 */
	public static final String PROCESSING_FAILURE_STATUS = "FAILURE DURING PROCESSING";

	/**
	 * General Write Failure Job Exit Status.
	 */
	public static final String WRITE_FAILURE_STATUS = "FAILURE DURING WRITE";

	/**
	 * General Data Error Job Exit Status.
	 */
	public static final String DATA_ERROR_STATUS = "DATA ERROR DETECTED";

	/**
	 * General Empty File Job Exit Status.
	 */
	public static final String EMPTY_FILE_ERROR_STATUS = "EMPTY INPUT FILE";

	/**
	 * General Incomplete File Job Exit Status.
	 */
	public static final String INCOMPLETE_FILE_ERROR_STATUS = "INCOMPLETE FILE";

	/**
	 * Default file extension that indicates associated file upload is
	 * successfully finished.
	 */
	public static final String DEFAULT_FILE_DONE_EXTENSION = ".don";

	/**
	 * Default file extension for complete data files.
	 */
	public static final String DEFAULT_FILE_DATA_EXTENSION = ".txt";

	/**
	 * Paging results size for paging reader / processor / writer
	 */
    public static final String RESULTS_SIZE_KEY = "ResultsSize";
}
