package gov.va.cpss.jasper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PdfSiteStatementBean {

	private String facility;
	private String total;
	private String totalLabel;
	private Boolean lateStmtFlag = Boolean.FALSE;
	private Boolean delimiterFlag = Boolean.TRUE;
	private Boolean trailingSpaceFlag = Boolean.TRUE;
	private List<PdfSiteStatementEntryBean> records = new ArrayList<>();
	private List<String> fillerSpace = new ArrayList<>();

	public String getFacility() {
		return facility;
	}

	public void setFacility(String facility) {
		this.facility = facility;
	}

	public String getTotal() {
		return total;
	}

	public void setTotal(String total) {
		this.total = total;
	}

	public String getTotalLabel() {
		return totalLabel;
	}

	public void setTotalLabel(String totalLabel) {
		this.totalLabel = totalLabel;
	}
	
	public Boolean getLateStmtFlag() {
		return lateStmtFlag;
	}

	public void setLateStmtFlag(Boolean lateStmtFlag) {
		this.lateStmtFlag = lateStmtFlag;
	}

	public Boolean getDelimiterFlag() {
		return delimiterFlag;
	}

	public void setDelimiterFlag(Boolean delimiterFlag) {
		this.delimiterFlag = delimiterFlag;
	}

	public Boolean getTrailingSpaceFlag() {
		return trailingSpaceFlag;
	}

	public void setTrailingSpaceFlag(Boolean trailingSpaceFlag) {
		this.trailingSpaceFlag = trailingSpaceFlag;
	}

	public List<PdfSiteStatementEntryBean> getRecords() {
		return records;
	}

	public void setRecords(List<PdfSiteStatementEntryBean> records) {
		this.records = records;
	}

	public List<String> getFillerSpace() {
		return fillerSpace;
	}

	public void setFillerSpace(List<String> fillerSpace) {
		this.fillerSpace = fillerSpace;
	}

	/**
	 * Return the size of the bean in units of lines that would be written to the report.
	 * @return Integer representing the number of lines.
	 */
	public int size() {
		int s = 0;
		if (facility != null) {
			++s;
		}
		if (total != null) {
			++s;
		}
		if (delimiterFlag) {
			++s;
		}
		if (trailingSpaceFlag) {
			++s;
		}
		s += records.size();
		
		return s;
	}
	
	/**
	 * Split the bean into two beans.  The existing bean will be truncated and a new bean with the truncated portion will be created and returned.
	 * @param length The length allowed before truncation of the original bean.
	 * @return A new bean with the truncated portion.
	 */
	public PdfSiteStatementBean split(final int length) {
		
		PdfSiteStatementBean truncatedBean = new PdfSiteStatementBean();
		truncatedBean.setDelimiterFlag(false);
		
		// Only truncate if size bigger than allowed length.
		if (size() > length) {
			
			// Calculate the number of records that need to be removed.
			//int removeAmount = size() - length;
			int removeAmount = length;
			
			// If 1 or more then set trailing space flag to false.
			if (removeAmount >= 1 ) {
				trailingSpaceFlag = false;
				truncatedBean.setTrailingSpaceFlag(false);
			}
			
			// If 2 or more then set total to null.			
			if (removeAmount >= 2) { 
				truncatedBean.setTotal(total);
				truncatedBean.setTotalLabel(totalLabel);
				truncatedBean.setTrailingSpaceFlag(true);
				total = null;
				totalLabel = null;
			}
			
			// If 3 or more then set delimiter flag to false.
			if (removeAmount >= 3) {
				delimiterFlag = false;
				truncatedBean.setDelimiterFlag(true);
			}
			
			// If 4 or more then remove records and possibly the facility.
			if (removeAmount >= 4) {
				final int nonRecordLines = 3; // total + delimiter + trailing space = 3
				
				// Determine how many records to remove.
				final int recordRemoveCount = removeAmount - nonRecordLines;
				
				if (recordRemoveCount > records.size()) {
					
					truncatedBean.setFacility(facility);
					truncatedBean.setRecords(records);
					
					records = new ArrayList<>();
					
					facility = null;
				} else {
					
					List<PdfSiteStatementEntryBean> truncatedList = new ArrayList<>();
					
					int deletedIndex = records.size() - recordRemoveCount;
					for (int i = records.size() - 1; i >= deletedIndex; --i) {
						PdfSiteStatementEntryBean entryBean = records.remove(i);
						
						truncatedList.add(entryBean);
					}
					
					// Flip the order.
					Collections.reverse(truncatedList);
					truncatedBean.setRecords(truncatedList);
				}
			}
		} 
		return truncatedBean;
	}
	
}
