package gov.va.cpss.email;

/**
 * Interface for configuring SMTP mail properties. Implementation should ensure
 * that the desired mail related properties are configured as system properties
 * for use by javax.mail.
 * 
 * @author Brad Pickle
 *
 */
public interface SmtpMailConfigurer {

	public static final String MAIL_SMTP_HOST_PROPERTY = "mail.smtp.host";

	public static final String MAIL_SMTP_PORT_PROPERTY = "mail.smtp.port";

	public static final String DEFAULT_MAIL_SMTP_HOST = "localhost";

	public static final int DEFAULT_MAIL_SMTP_PORT = POR;

	/**
	 * Return the mail.smtp.host property that will be used by the javax.mail
	 * system.
	 * 
	 * @return String mail.smtp.host property.
	 */
	String getMailSmtpHost();

	/**
	 * Set the mail.smtp.host property that will be used by the javax.mail
	 * system.
	 * 
	 * @param mailSmtpHost
	 *            mail.smtp.host property.
	 */
	void setMailSmtpHost(String mailSmtpHost);

	/**
	 * Return the mail.smtp.port property that will be used by the javax.mail
	 * system.
	 * 
	 * @return String mail.smtp.port property.
	 */
	String getMailSmtpPort();

	/**
	 * Set the mail.smtp.port property that will be used by the javax.mail
	 * system.
	 * 
	 * @param mailSmtpPort
	 *            mail.smtp.port property.
	 */
	void setMailSmtpPort(String mailSmtpPort);

}
