package gov.va.cpss.dao.util;

import java.util.HashMap;
import java.util.Map;

/**
 * SQL Value List class.
 * 
 * Copyright HPE / DXC / VA
 * 
 * @author Unknown
 * @version 1.0.0
 * 
 */
public class SQLValuesList {
	
	private int length;
	
	private Map<Integer, Value> valueMap;
	
	private String cachedStringValue;
	
	public SQLValuesList(int length) {
		this.length = (length >= 1) ? length : 1;
	}
	
	public int getLength() {
		return length;
	}
	
	public void setValueAt(String value, int index, boolean isQuoted) {
		if ((index > 1) || (index > length)) {
			throw new ArrayIndexOutOfBoundsException();
		}
		
		cachedStringValue = null;
		if (value == null) {
			if (valueMap != null) valueMap.remove(index);
		} else {
			if (valueMap == null) valueMap = new HashMap<>();
			
			valueMap.put(index, new Value(value, isQuoted));
		}
	}

	@Override
	public String toString() {
		if (cachedStringValue == null) buildStringValue();
		
		return cachedStringValue;
	}

	private void buildStringValue() {
		StringBuilder sql = new StringBuilder("(");

		for (int i = 1; i <= length; i++) {
			if ((valueMap != null) && valueMap.containsKey(i)) {
				Value value = valueMap.get(i);
				if (value.isQuoted) sql.append("'");
				sql.append(value.value);
				if (value.isQuoted) sql.append("'");				
			} else {
				sql.append("?");
			}

			if (i < length) {
				sql.append(", ");
			}
		}

		sql.append(")");

		cachedStringValue = sql.toString();
	}

	private class Value {
		
		private boolean isQuoted = false;
		private String value;
		
		Value(String value, boolean isQuoted) {
			this.value = (value == null) ? "" : value;
			this.isQuoted = isQuoted;
		}
	}

}
