package gov.va.cpss.dao.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.List;

import org.springframework.jdbc.core.BatchPreparedStatementSetter;

import gov.va.cpss.dao.VistaAcntHistDAO;
import gov.va.cpss.model.CBSSAbstractModel;
import gov.va.cpss.model.ProcessStatus.Status;
import gov.va.cpss.model.icn.VistaAcntHist;

/**
 *
 * VistA Account History DAO Implementation.
 *
 * Sprint 5 - Epic 349068, Task 370262 DAO Implementation.
 *
 * Copyright HPE / VA
 * August 29, 2016
 *
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
@SuppressWarnings("nls")
public class VistaAcntHistDAOImpl extends CBSSBaseDAOImpl implements VistaAcntHistDAO
{
	// Select a list of Vista Account History based on DFN and Station Number
	@Override
	public List<VistaAcntHist> selectByDfnSite(long dfn, String stationNum)
	{
		String sql = "SELECT * FROM " + getTableName() + " WHERE DFN = " + dfn + " AND STATIONNUM = '" + stationNum + "'";

		return this.jdbcTemplate.query(sql, new VistaAcntHistRowMapper());
	}

	// Select a list of VistA Account History based its status
	@Override
	public List<VistaAcntHist> select(int statusID)
	{
		String sql = "SELECT * FROM " + getTableName() + " WHERE STATUSID = " + statusID + " ORDER BY MODIFIEDDATE";

		return this.jdbcTemplate.query(sql, new VistaAcntHistRowMapper());
	}

	// Update VistA Account History with a new status
	@Override
	public int[] update(long[] inIDs, int statusID)
	{
		String sql = "UPDATE " + getTableName() + " SET STATUSID = " + statusID + "WHERE ID = ?";

		return
		this.jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter()
		{
			@Override
			public void setValues(PreparedStatement ps, int i) throws SQLException
			{
				ps.setLong(1, inIDs[i]);
			}

			@Override
			public int getBatchSize()
			{
				return inIDs.length;
			}
		});
	}


	// This batch insert method is NOT ready yet, will be updated later. - YPY
	/* (non-Javadoc)
	 * @see gov.va.cpss.dao.VistaAcntHistDAO#batchInsert(java.lang.Long[], java.lang.String[], java.lang.String[], java.lang.String[])
	 */
	@Override
	public int[] batchInsert(Long[] inDFNs, String[] inStationNumbers, String[] inNewICNs, String[] inOldICNs)
	{
		String sql = "INSERT INTO " + getTableName() + " (DFN, STATIONNUM, NEWICN, OLDICN, STATUSID) VALUES (?, ?, ?, ?, ?)";

		return
		this.jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter()
		{
			@Override
			public void setValues(PreparedStatement ps, int i) throws SQLException
			{
				ps.setLong(1, inDFNs[i].longValue());
				ps.setString(2, inStationNumbers[i]);
				ps.setString(3, inNewICNs[i]);
				ps.setString(4, inOldICNs[i]);
				ps.setInt(5, getStatusID(Status.NEW));
			}

			@Override
			public int getBatchSize()
			{
				return inOldICNs.length;
			}
		});
	}

	@Override
	public String getTableName()
	{
		return "VistaAcntHist";
	}

	@Override
	public List<VistaAcntHist> select(Status inStatus)
	{
		int statusID = getStatusID(inStatus);

		if (statusID < 0)
		{
			return null;
		}

		List<VistaAcntHist> vistaAcntHistories = select(statusID);

		// Set the Status from Status ID
		// (This may not be needed if ProcessStatus can directly convert between Status and Status ID.)
		for (VistaAcntHist vistaAcntHist : vistaAcntHistories)
		{
			vistaAcntHist.setStatus(getStatus(vistaAcntHist.getStatusId()));
		}

		return vistaAcntHistories;
	}

	@Override
	public int[] update(long[] inIDs, Status inStatus)
	{
		int statusID = getStatusID(inStatus);

		if (statusID < 0)
		{
			return null;
		}

		return update(inIDs, statusID);
	}

	@Override
	public int[] update(List<VistaAcntHist> inVistaAcntHistories, Status inStatus)
	{
		for (int i = 0; i < inVistaAcntHistories.size(); i++)
		{
			inVistaAcntHistories.get(i).setStatus(inStatus);
		}

		return update(inVistaAcntHistories);
	}

	@Override
	public int[] update(List<VistaAcntHist> inVistaAcntHistories)
	{
		String sql = "UPDATE " + getTableName() + " SET OLDCBSSACNTID = ?, STATUSID = ?" + "WHERE ID = ?";

		return
		this.jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter()
		{
			@Override
			public void setValues(PreparedStatement ps, int i) throws SQLException
			{
				if (inVistaAcntHistories.get(i).getOldCbssAcntId() > 0)
				{
					ps.setLong(1, inVistaAcntHistories.get(i).getOldCbssAcntId());
				}
				else
				{
					ps.setNull(1, Types.BIGINT);
				}

				ps.setInt(2, getStatusID(inVistaAcntHistories.get(i).getStatus()));
				ps.setLong(3, inVistaAcntHistories.get(i).getId());
			}

			@Override
			public int getBatchSize()
			{
				return inVistaAcntHistories.size();
			}
		});
	}

    @Override
    public String getInsertSQL()
    {
        return null;
    }

    @Override
    protected void mapRows(PreparedStatement ps, CBSSAbstractModel model) throws SQLException
    {
        return;
    }

    @Override
    protected CBSSAbstractModel mapResult(ResultSet rs) throws SQLException
    {
        return null;
    }
}
