package gov.va.cpss.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

//import javax.sql.DataSource;

//import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
//import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

//import gov.va.cpss.dao.CBSSAuditDatesDAO;
import gov.va.cpss.dao.VistaAccountDAO;
import gov.va.cpss.model.CBSSAbstractModel;
import gov.va.cpss.model.icn.VistaAccount;

/**
 * An implementation of the VistaAccountDAO interface.
 */
@SuppressWarnings("nls")
public class VistaAccountDAOImpl extends CBSSBaseDAOImpl implements VistaAccountDAO {

	// private final Logger daoLogger =
	// Logger.getLogger(VistaAccountDAOImpl.class.getCanonicalName());

	// private JdbcTemplate jdbcTemplate;

	// public void setDataSource(DataSource dataSource) {
	// this.jdbcTemplate = new JdbcTemplate(dataSource);
	// }

	@Override
	public boolean save(final int statusId, final long dfn, final String stationNum, final String icnNumber,
			final long cbssAcntId) {
		// insert
		final String sql = "INSERT INTO VistaAccount (DFN, stationNum, ICN, cbssAcntId, statusId) VALUES (?, ?, ?, ?, ?)";

		return (jdbcTemplate.update(new PreparedStatementCreator() {
			@Override
			public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(sql);
				ps.setLong(1, dfn);
				ps.setString(2, stationNum);
				ps.setString(3, icnNumber);
				ps.setLong(4, cbssAcntId);
				ps.setInt(5, statusId);
				return ps;
			}
		}) == 1);
	}

	@Override
	public boolean exists(final long dfn, final String stationNum) {

		VistaAccount vistaAccount = getVistaAccount(dfn, stationNum);

		if (vistaAccount != null) {
			return true;
		}

		return false;
	}

	/**
	 * Maps a ResultSet to a new VistaAccount object.
	 */
	private class VistaAccountRowMapper implements RowMapper<VistaAccount> {

		public VistaAccountRowMapper() {
			// Auto-generated constructor stub
		}

		@Override
		public VistaAccount mapRow(ResultSet rs, int rowNum) throws SQLException {

			VistaAccount vistaAccount = new VistaAccount();

			vistaAccount.setDfn(rs.getLong("DFN"));
			vistaAccount.setStationNum(rs.getString("stationNum"));
			vistaAccount.setIcn(rs.getString("ICN"));
			vistaAccount.setCbssAcntId(rs.getLong("cbssAcntId"));
			vistaAccount.setStatusId(rs.getInt("statusId"));

			// Audit fields
			vistaAccount.setCreatedBy(rs.getString("CREATEDBY"));
			vistaAccount.setCreatedDate(rs.getDate("CREATEDDATE"));
			vistaAccount.setModifiedBy(rs.getString("MODIFIEDBY"));
			vistaAccount.setModifiedDate(rs.getDate("MODIFIEDDATE"));

			return vistaAccount;
		}

	}

	@Override
	public int[] update(List<VistaAccount> inVistaAccounts) {
		String sql = "UPDATE " + getTableName() + " SET ICN = ?, CBSSACNTID = ?" + "WHERE DFN = ? AND STATIONNUM = ?";

		return this.jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter() {
			@Override
			public void setValues(PreparedStatement ps, int i) throws SQLException {
				ps.setString(1, inVistaAccounts.get(i).getIcn());
				ps.setLong(2, inVistaAccounts.get(i).getCbssAcntId());
				ps.setLong(3, inVistaAccounts.get(i).getDfn());
				ps.setString(4, inVistaAccounts.get(i).getStationNum());
			}

			@Override
			public int getBatchSize() {
				return inVistaAccounts.size();
			}
		});
	}

	@Override
	public String getTableName() {
		return "VistaAccount";
	}

	/*
	 * Deprecated, and currently only used by unit tests. This implementation
	 * will fail for batches of more than 1000 ICNs because of a limitation with
	 * the Oracle driver of only supporting up to 1000 parameters in a prepared
	 * statement. If this functionality is needed in the future, the algorithm
	 * should be refactored to limit the batch size. - Brad Pickle - 1/5/2017
	 * 
	 * @see gov.va.cpss.dao.VistaAccountDAO#batchSelect(java.lang.String[])
	 */
	@Override
	@Deprecated
	public List<VistaAccount> batchSelect(String[] inICNs) {
		String sql = buildBatchSelectSQL(inICNs.length);

		this.logger.debug(sql);

		// Query DB and extract data
		return this.jdbcTemplate.query(sql, inICNs, new ResultSetExtractor<List<VistaAccount>>() {
			@Override
			public List<VistaAccount> extractData(ResultSet rs) throws SQLException, DataAccessException {
				List<VistaAccount> vistaAccounts = null;

				if (rs.isBeforeFirst()) {
					VistaAccount vistaAccount;
					VistaAccountRowMapper rowMapper = new VistaAccountRowMapper();
					vistaAccounts = new ArrayList<>();

					while (rs.next()) {
						vistaAccount = rowMapper.mapRow(rs, 0);

						vistaAccounts.add(vistaAccount);
					}
				}

				return vistaAccounts;
			}
		});
	}

	// Build batch select SQL.
	private String buildBatchSelectSQL(int length) {
		StringBuilder sql = new StringBuilder();

		sql.append("SELECT * FROM " + getTableName() + " WHERE ICN IN (");

		for (int i = 0; i < length; i++) {
			sql.append("?");

			if (i + 1 < length) {
				sql.append(", ");
			}
		}

		sql.append(")");

		return sql.toString();
	}

	// Since DFN and StationNum are the only primary keys of VistA Account
	// table,
	// only one VistA Account should be returned, if there is one.
	@Override
	public VistaAccount getVistaAccount(long inDFN, String inStationNum) {
		final String sql = "SELECT * FROM " + getTableName() + " WHERE DFN = ? AND STATIONNUM = ?";

		List<VistaAccount> vistaAccounts = this.jdbcTemplate.query(new PreparedStatementCreator() {
			@Override
			public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(sql);
				ps.setLong(1, inDFN);
				ps.setString(2, inStationNum);

				return ps;
			}
		}, new VistaAccountRowMapper());

		if (vistaAccounts == null || vistaAccounts.isEmpty()) {
			return null;
		}

		return vistaAccounts.get(0);
	}

    @Override
    public String getInsertSQL()
    {
        return null;
    }

    @Override
    protected void mapRows(PreparedStatement ps, CBSSAbstractModel model) throws SQLException
    {
        return;
    }

    @Override
    protected CBSSAbstractModel mapResult(ResultSet rs) throws SQLException
    {
        return null;
    }
}
