package gov.va.cpss.dao.impl;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.log4j.Logger;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;

import gov.va.cpss.model.bal.SiteBalance;

/**
 * Custom ItemPreparedStatementSetter for JdbcBatchItemWriter to set values in
 * prepared statement for batch data insert into the CBSSiteTrans table.
 * 
 * @author DNS   
 */
public class SiteBalanceNewPreparedStatementSetter implements ItemPreparedStatementSetter<SiteBalance> {

	private final Logger setterLogger;

	public SiteBalanceNewPreparedStatementSetter() {
		setterLogger = Logger.getLogger(this.getClass().getCanonicalName());
	}

	@Override
	public void setValues(SiteBalance siteBalance, PreparedStatement ps) throws SQLException {

		setterLogger.debug("Setting values to insert SiteBal row");

		ps.setLong(1, siteBalance.getPatientDfn());
		ps.setString(2, siteBalance.getStationNum());
		ps.setString(3, siteBalance.getOldAcctNum());
		ps.setDouble(4, siteBalance.getBalance());
		ps.setDate(5, new Date(siteBalance.getOldestBillDate().getTime()));
		ps.setDate(6, new Date(siteBalance.getProcessDate().getTime()));
		ps.setLong(7, siteBalance.getSiteBalRec().getId());
	}

}
