package gov.va.cpss.dao.impl;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.log4j.Logger;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;

import gov.va.cpss.model.bal.SiteBalance;

public class SiteBalanceExistingPreparedStatementSetter implements ItemPreparedStatementSetter<SiteBalance> {

	private final Logger setterLogger;

	public SiteBalanceExistingPreparedStatementSetter() {
		setterLogger = Logger.getLogger(this.getClass().getCanonicalName());
	}
	
	@Override
	public void setValues(SiteBalance siteBalance, PreparedStatement ps) throws SQLException {
		setterLogger.debug("Setting values to update SiteBal row");
		
		ps.setDouble(1, siteBalance.getBalance());
		ps.setDate(2, new Date(siteBalance.getOldestBillDate().getTime()));
		ps.setDate(3, new Date(siteBalance.getProcessDate().getTime()));
		ps.setLong(4, siteBalance.getSiteBalRec().getId());
		ps.setLong(5, siteBalance.getPatientDfn());
		ps.setString(6, siteBalance.getStationNum());
	}
}
