package gov.va.cpss.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

import gov.va.cpss.dao.SiteBalRecDAO;
import gov.va.cpss.model.bal.SiteBalRec;

public class SiteBalRecDAOImpl implements SiteBalRecDAO{

	JdbcTemplate jdbcTemplate;
	
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }
	
	@Override
	public SiteBalRec getById(long id) {
		final String sql = "SELECT * FROM SiteBalRec WHERE id=" + id;

		return jdbcTemplate.query(sql, new ResultSetExtractor<SiteBalRec>() {

			@Override
			public SiteBalRec extractData(ResultSet rs) throws SQLException, DataAccessException {
				if (rs.next()) {
					SiteBalRec siteBalRec = new SiteBalRec(rs.getLong("id"));
					siteBalRec.setBatchRunId(rs.getLong("batchRunId"));
					siteBalRec.setFileName(rs.getString("fileName"));
					siteBalRec.setTotNumFacility(rs.getInt("totNumFacility"));
					siteBalRec.setTotNumPatient(rs.getInt("totNumPatient"));
					return siteBalRec;
				}

				return null;
			}
		});
	}
	
	@Override
	public long save(SiteBalRec siteBalRec) {

		// insert
		final String sql = "INSERT INTO SiteBalRec(fileName, batchRunId, totNumFacility, totNumPatient, statusid) VALUES (?, ?, ?, ?, ?)";
		KeyHolder keyHolder = new GeneratedKeyHolder();

		jdbcTemplate.update(new PreparedStatementCreator() {
			@Override
			public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(sql, new String[] { "id" });

				ps.setString(1, siteBalRec.getFileName());
				ps.setLong(2, siteBalRec.getBatchRunId());
				ps.setInt(3, siteBalRec.getTotNumFacility());
				ps.setInt(4, siteBalRec.getTotNumPatient());
				ps.setInt(5, siteBalRec.getProcessStatus());

				return ps;
			}
		}, keyHolder);

		return keyHolder.getKey().longValue();
	}
	
	@Override
	public void deleteById(long id) {
		final String sql = "DELETE FROM SiteBalRec where id = ?";
		jdbcTemplate.update(sql, id);
	}

	@Override
	public void updateResults(SiteBalRec siteBalRec) {
		final String sql = "UPDATE SiteBalRec SET statusId=?, totNumPatient=?, totNumFacility=? WHERE id=?";
		jdbcTemplate.update(sql, siteBalRec.getProcessStatus(), siteBalRec.getTotNumPatient(), siteBalRec.getTotNumFacility(),
				siteBalRec.getId());
	}
}
