package gov.va.cpss.dao.impl;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

import gov.va.cpss.dao.SiteBalDAO;
import gov.va.cpss.dao.SiteBalRecDAO;
import gov.va.cpss.model.bal.SiteBalance;

public class SiteBalDAOImpl implements SiteBalDAO{

	private JdbcTemplate jdbcTemplate;
	
	private SiteBalRecDAO siteBalRecDAO;
	
	public SiteBalDAOImpl() {
	}
	
	public SiteBalRecDAO getSiteBalRecDAO() {
		return siteBalRecDAO;
	}

	public void setSiteBalRecDAO(SiteBalRecDAO siteBalRecDAO) {
		this.siteBalRecDAO = siteBalRecDAO;
	}
	
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }
	
	@Override
	public SiteBalance getById(final long id) {
		final String sql = "SELECT * FROM SiteBal WHERE id = " + id;

		return jdbcTemplate.query(sql, new ResultSetExtractor<SiteBalance>() {
			
			@Override
			public SiteBalance extractData(ResultSet rs) throws SQLException, DataAccessException {
				if (rs.next()) {
					SiteBalance siteBalance = new SiteBalance(rs.getLong("id"));
					siteBalance.setOldAcctNum(rs.getString("oldAcntNum"));
					siteBalance.setPatientDfn(rs.getLong("dfn"));
					siteBalance.setStationNum(rs.getString("stationNum"));
					siteBalance.setBalance(rs.getDouble("balance"));
					siteBalance.setOldestBillDate(rs.getDate("oldestBillDate"));
					siteBalance.setPatientAcctBalMsg(null);
					siteBalance.setSiteBalRec(siteBalRecDAO.getById(rs.getLong("siteBalRecId")));
					return siteBalance;
				}

				return null;
			}

		});
	}
	
	@Override
	public long save(SiteBalance siteBalance) {
		final String sql = "INSERT INTO SiteBal (dfn, stationNum, oldAcntNum, balance, oldestBillDate, siteBalRecId, patAcntBalMsgId, processDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
		KeyHolder keyHolder = new GeneratedKeyHolder();

		jdbcTemplate.update(new PreparedStatementCreator() {
			@Override
			public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(sql, new String[] { "id" });
				ps.setLong(1, siteBalance.getPatientDfn());
				ps.setString(2, siteBalance.getStationNum());
				ps.setString(3, siteBalance.getOldAcctNum());
				ps.setDouble(4, siteBalance.getBalance());
				ps.setDate(5, new Date(siteBalance.getOldestBillDate().getTime()));
				ps.setLong(6, siteBalance.getSiteBalRec().getId());
				ps.setLong(7, siteBalance.getPatientAcctBalMsg().getId());
				ps.setDate(8, new java.sql.Date(siteBalance.getProcessDate().getTime()));
				return ps;
			}
		}, keyHolder);
		siteBalance.setId(keyHolder.getKey().longValue());

		return siteBalance.getId();
	}
	
	@Override
	public SiteBalance getByAcctNumAndStationNum(long dfn, String stationNum) {
		final String sql = String.format("SELECT * FROM SiteBal WHERE dfn=%s AND stationNum='%s'", dfn, stationNum);

		return jdbcTemplate.query(sql, new ResultSetExtractor<SiteBalance>() {

			@Override
			public SiteBalance extractData(ResultSet rs) throws SQLException, DataAccessException {
				if (rs.next()) {
					SiteBalance siteBalance = new SiteBalance(rs.getLong("id"));
					siteBalance.setOldAcctNum(rs.getString("oldAcntNum"));
					siteBalance.setPatientDfn(rs.getLong("dfn"));
					siteBalance.setStationNum(rs.getString("stationNum"));
					siteBalance.setBalance(rs.getDouble("balance"));
					siteBalance.setOldestBillDate(rs.getDate("oldestBillDate"));
					siteBalance.setProcessDate(rs.getDate("processDate"));
					siteBalance.setPatientAcctBalMsg(null);
					siteBalance.setSiteBalRec(siteBalRecDAO.getById(rs.getLong("siteBalRecId")));
					return siteBalance;
				}

				return null;
			}
		});
	}
	
	public static String getInsertSiteBalSql() {
		return "insert into SiteBal(dfn,stationNum,oldAcntNum,balance,oldestBillDate,processDate,siteBalRecId) " +
				"values(?,?,?,?,?,?,?)";
	}
	
	public static String getUpdateSiteBalSql() {
		return "update SiteBal set balance=?, oldestBillDate=?, processDate=?, siteBalRecId=? "
				+ "where dfn=? and stationNum=?";
	}
	
	public void updateSiteBalPatAcntBalMsgId(Long msgId)
	{		
		// update
        String sql = "UPDATE Sitebal SET patAcntBalMsgId = ? WHERE balance > 0";
        jdbcTemplate.update(sql, msgId);
	}
	
	public Integer getTotalRecordsFromSiteBalToProcess()
	{
		String sql = "SELECT COUNT(*) FROM SITEBAL WHERE balance > 0";
		return jdbcTemplate.queryForObject(sql, Integer.class);
		
	}
}
