package gov.va.cpss.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.model.bal.SiteBalance;
import gov.va.cpss.model.cbs.CBSAccount;

public class SendBillDataDAOImpl implements RowMapper<SiteBalance> {

	
	@Override
	public SiteBalance mapRow(ResultSet rs, int rowNum) throws SQLException {
		
		SiteBalance billData = new SiteBalance(rs.getLong("siteBal_id"));
		CBSAccount cbsAccount = new CBSAccount();
		cbsAccount.setId(rs.getLong("cbsAccount_id"));
		billData.setCbsAccount(cbsAccount);
		billData.setId(rs.getLong("sitebal_id"));
		billData.setPatientDfn(rs.getLong("sitebal_dfn"));
		billData.setStationNum(rs.getString("sitebal_stationnum"));
		billData.setOldAcctNum(rs.getString("sitebal_oldacntnum"));
		billData.setOldestBillDate(rs.getDate("sitebal_oldestbilldate"));
		billData.setBalance(rs.getDouble(("sitebal_balance")));

		return billData;
	}
	
	public static String getJoinCBSAccountSql() {
		return "SELECT vistaAccount.cbssAcntId AS cbsAccount_id, "
				+ "siteBal.id AS sitebal_id, "
				+ "siteBal.dfn AS sitebal_dfn, "
				+ "siteBal.stationNum AS sitebal_stationnum, "
				+ "siteBal.oldAcntNum AS sitebal_oldacntnum, "
				+ "siteBal.balance AS sitebal_balance, "
				+ "siteBal.oldestBillDate AS sitebal_oldestbilldate "
				+ "FROM vistaAccount JOIN siteBal "
				+ "  ON vistaAccount.dfn = siteBal.dfn "
				+ "     AND vistaAccount.stationNum = siteBal.stationNum "
				+ "WHERE siteBal.balance > 0 "
				+ "ORDER BY vistaAccount.cbssAcntId ASC ";
	}
}
