package gov.va.cpss.dao.impl;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.log4j.Logger;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;

import gov.va.cpss.model.fps.PSSite;

/**
 * Custom ItemPreparedStatementSetter for JdbcBatchItemWriter to set values in prepared statement
 * for batch data insert into the PSSite table.
 * 
 * @author DNS  
 */
public class PSSiteItemPreparedStatementSetter implements ItemPreparedStatementSetter<PSSite> {

    private final Logger processorLogger;

    public PSSiteItemPreparedStatementSetter() {
        processorLogger = Logger.getLogger(this.getClass().getCanonicalName());
    }

    @Override
    public void setValues(PSSite arg0, PreparedStatement arg1) throws SQLException {

        processorLogger.info("Setting values to insert PS row");

        arg1.setLong(1, arg0.getPsReceivedId());
        arg1.setInt(2, arg0.getSeqNum());
        arg1.setInt(3, arg0.getTotSeqNum());
        arg1.setString(4, arg0.getFacilityNum());
        arg1.setString(5, arg0.getFacilityPhoneNum());
        arg1.setInt(6, arg0.getTotStatement());
        arg1.setDouble(7, arg0.getStatementVal().getDouble());
        arg1.setString(8, arg0.getStatementVal().getCobol());
        arg1.setDate(9, new Date(arg0.getStatementDate().getTime()));
        arg1.setDate(10, new Date(arg0.getProcessDate().getTime()));
        arg1.setString(11, arg0.getCreatedBy());
        arg1.setDate(12, new Date((new java.util.Date()).getTime()));
        arg1.setString(13, arg0.getModifiedBy());
        arg1.setDate(14, new Date((new java.util.Date()).getTime()));
    }

}
