package gov.va.cpss.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

import gov.va.cpss.dao.PSReceivedDAO;
import gov.va.cpss.model.fps.PSReceived;

/**
 * An implementation of the PSReceivedDAO interface.
 */
public class PSReceivedDAOImpl implements PSReceivedDAO {

	private JdbcTemplate jdbcTemplate;

	public PSReceivedDAOImpl() {
	}

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public long save(final PSReceived psReceived) {

		// insert
		final String sql = "INSERT INTO PSReceived (numOfSite, numOfStatement, dateReceived, status_Id, fileName, batchRun_Id) VALUES (?, ?, ?, ?, ?, ?)";
		KeyHolder keyHolder = new GeneratedKeyHolder();

		jdbcTemplate.update(new PreparedStatementCreator() {
			@Override
			public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(sql, new String[] { "id" });

				ps.setLong(1, psReceived.getNumOfSite());
				ps.setLong(2, psReceived.getNumOfStatement());
				ps.setTimestamp(3, psReceived.getDateReceived());
				ps.setInt(4, psReceived.getStatusId());
				ps.setString(5, psReceived.getFileName());
				ps.setInt(6, psReceived.getBatchRunId());
				
				return ps;
			}
		}, keyHolder);

		return keyHolder.getKey().longValue();
	}

	@Override
	public void updateStatus(final PSReceived psReceived) {

		final String sql = "UPDATE PSReceived SET status_Id = ? where id=?";
		jdbcTemplate.update(sql, psReceived.getStatusId(), psReceived.getId());
	}

	@Override
	public void updateResults(final PSReceived psReceived) {

		final String sql = "UPDATE PSReceived SET status_Id=?, numOfSite=?, numOfStatement=? WHERE id=?";
		jdbcTemplate.update(sql, psReceived.getStatusId(), psReceived.getNumOfSite(), psReceived.getNumOfStatement(),
				psReceived.getId());
	}

	@Override
	public List<Long> getPSReceivedIDListByStatusID(final int status) {

		String sql = "SELECT id FROM PSReceived WHERE status_Id=? order by id";

		List<Long> idL = jdbcTemplate.query(sql, new PreparedStatementSetter() {
			public void setValues(PreparedStatement preparedStatement) throws SQLException {
				preparedStatement.setInt(1, status);
			}
		}, new RowMapper<Long>() {

			@Override
			public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
				Long id = rs.getLong("id");
				return id;
			}

		});

		return idL;
	}

	@Override
	public int updateStatusById(final long id, final int toStatus) {
		final String sql = "UPDATE PSReceived SET status_Id=? WHERE id=?";
		return jdbcTemplate.update(sql, toStatus, id);
	}
}
