package gov.va.cpss.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.cobol.Money;
import gov.va.cpss.model.BooleanChar;
import gov.va.cpss.model.fps.PSPatient;
import gov.va.cpss.model.fps.PSSite;

/**
 * Custom ItemPreparedStatementSetter for JdbcBatchItemWriter to set values in
 * prepared statement for batch data insert into the PSPatient table.
 * 
 * @author DNS  
 */
public class PSPatientRowMapper implements RowMapper<PSPatient> {

	@Override
	public PSPatient mapRow(ResultSet rs, int rowNum) throws SQLException {

		PSPatient patient = new PSPatient();

		patient.setId(rs.getInt(1));
		patient.setPsSite(new PSSite(rs.getLong(2)));
		patient.setPatientAccount(rs.getString(3));
		patient.setPatientLastName(rs.getString(4));
		patient.setPatientFirstName(rs.getString(5));
		patient.setPatientMiddleName(rs.getString(6));
		patient.setAddress1(rs.getString(7));
		patient.setAddress2(rs.getString(8));
		patient.setAddress3(rs.getString(9));
		patient.setCity(rs.getString(10));
		patient.setState(rs.getString(11));
		patient.setZipCode(rs.getString(12));
		patient.setCountryName(rs.getString(13));
		patient.setAmountDue(new Money(rs.getString(15))); // Generate from raw
															// Cobol
		patient.setPrevBalance(new Money(rs.getString(17))); // Generate from
																// raw Cobol
		patient.setTotalCharges(new Money(rs.getString(19))); // Generate from
																// raw Cobol
		patient.setTotalCredits(new Money(rs.getString(21))); // Generate from
																// raw Cobol
		patient.setNewBalance(new Money(rs.getString(23))); // Generate from raw
															// Cobol
		patient.setSpecialNotes(rs.getString(24));
		patient.setSpecialNotesForLateSites1(rs.getString(25));
		patient.setSpecialNotesForLateSites2(rs.getString(26));
		patient.setRightsObligationParagraphCodes(rs.getString(27));
		patient.setNumOfLines(rs.getInt(28));
		patient.setDfnNumber(rs.getLong(29));
		patient.setLargeFontInd(BooleanChar.from(rs.getString(30)));
		patient.setIcnNumber(rs.getString(31));
		patient.setAddressFlag(BooleanChar.from(rs.getString(32)));
		patient.setLastBillPrepDate(rs.getDate(33));
		patient.setCreatedBy(rs.getString(34));
		patient.setCreatedDate(new java.util.Date(rs.getDate(35).getTime()));
		patient.setModifiedBy(rs.getString(36));
		patient.setModifiedDate(new java.util.Date(rs.getDate(37).getTime()));

		return patient;
	}

}
