package gov.va.cpss.dao.impl;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

import gov.va.cpss.cobol.Money;
import gov.va.cpss.dao.CBSSAuditDatesDAO;
import gov.va.cpss.dao.PSPatientDAO;
import gov.va.cpss.model.BooleanChar;
import gov.va.cpss.model.fps.PSPatient;
import gov.va.cpss.model.fps.PSSite;

/**
 * An implementation of the PSPatientDAO interface.
 */
public class PSPatientDAOImpl implements PSPatientDAO {

	private JdbcTemplate jdbcTemplate;

	private CBSSAuditDatesDAO cbssAuditDatesDAO;

	public PSPatientDAOImpl() {
	}

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	public CBSSAuditDatesDAO getCbssAuditDatesDAO() {
		return cbssAuditDatesDAO;
	}

	public void setCbssAuditDatesDAO(CBSSAuditDatesDAO cbssAuditDatesDAO) {
		this.cbssAuditDatesDAO = cbssAuditDatesDAO;
	}

	@Override
	public Long getLastIndex() {

		// query
		final String sql = "SELECT * FROM (SELECT * FROM PSPatient ORDER BY id DESC) WHERE rownum <= 1";

		List<Long> results = jdbcTemplate.query(sql, new RowMapper<Long>() {
			@Override
			public Long mapRow(ResultSet rs, int row) throws SQLException {
				return new Long(rs.getLong(1));
			}
		});

		if ((results != null) && !results.isEmpty()) {
			return results.get(0);
		}

		return null;
	}

	@Override
	public List<PSPatient> getAllByPSSiteID(final PSSite psSite) {

		if (psSite != null) {

			String sql = "SELECT * FROM PSPatient WHERE psSite_Id = " + psSite.getId() + " order by id";
			List<PSPatient> patientL = jdbcTemplate.query(sql, new RowMapper<PSPatient>() {

				@Override
				public PSPatient mapRow(ResultSet rs, int rowNum) throws SQLException {

					PSPatient patient = new PSPatient();

					patient.setId(rs.getInt("id"));
					patient.setPsSite(psSite);
					patient.setPatientAccount(rs.getString("patientAccount"));
					patient.setPatientLastName(rs.getString("patientLastName"));
					patient.setPatientFirstName(rs.getString("patientFirstName"));
					patient.setPatientMiddleName(rs.getString("patientMiddleName"));
					patient.setAddress1(rs.getString("address1"));
					patient.setAddress2(rs.getString("address2"));
					patient.setAddress3(rs.getString("address3"));
					patient.setCity(rs.getString("city"));
					patient.setState(rs.getString("state"));
					patient.setZipCode(rs.getString("zipCode"));
					patient.setCountryName(rs.getString("countryName"));
					patient.setAmountDue(new Money(rs.getString("amountDueRaw"))); // Generate
																					// from
																					// raw
					// Cobol
					patient.setPrevBalance(new Money(rs.getString("prevBalanceRaw"))); // Generate
																						// from
					// raw Cobol
					patient.setTotalCharges(new Money(rs.getString("totalChargesRaw"))); // Generate
																							// from
					// raw Cobol
					patient.setTotalCredits(new Money(rs.getString("totalCreditsRaw"))); // Generate
																							// from
					// raw Cobol
					patient.setNewBalance(new Money(rs.getString("newBalanceRaw"))); // Generate
																						// from
																						// raw
					// Cobol
					patient.setSpecialNotes(rs.getString("specialNotes"));
					patient.setSpecialNotesForLateSites1(rs.getString("specialNotesForLateSites1"));
					patient.setSpecialNotesForLateSites2(rs.getString("specialNotesForLateSites2"));
					patient.setRightsObligationParagraphCodes(rs.getString("rightsObligationParagraphCodes"));
					patient.setNumOfLines(rs.getInt("numOfLines"));
					patient.setDfnNumber(rs.getLong("dfnNumber"));
					// Null is allowed.
					if (rs.getString("largeFontInd") == null) {
						patient.setLargeFontInd(BooleanChar.N);
					} else {
						patient.setLargeFontInd(BooleanChar.from(rs.getString("largeFontInd")));
					}
					patient.setIcnNumber(rs.getString("icnNumber"));
					patient.setAddressFlag(BooleanChar.from(rs.getString("addressFlag")));
					patient.setLastBillPrepDate(rs.getDate("lastBillPrepDate"));
					patient.setCreatedBy(rs.getString("createdBy"));
					patient.setCreatedDate(new java.util.Date(rs.getDate("createdDate").getTime()));
					patient.setModifiedBy(rs.getString("modifiedBy"));
					patient.setModifiedDate(new java.util.Date(rs.getDate("modifiedDate").getTime()));

					return patient;
				}
			});
			return patientL;
		}

		return null;
	}

	@Override
	public long save(PSPatient patient) {

		// insert
		final String sql = "insert into PSPatient (psSite_Id, patientAccount, patientLastName, patientFirstName, patientMiddleName, address1, address2, address3, city, state, zipCode, countryName, amountDue, amountDueRaw, prevBalance, prevBalanceRaw, totalCharges, totalChargesRaw, totalCredits, totalCreditsRaw, newBalance, newBalanceRaw, specialNotes, specialNotesForLateSites1, specialNotesForLateSites2, rightsObligationParagraphCodes, numOfLines, dfnNumber, largeFontInd, icnNumber, addressFlag, lastBillPrepDate) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
		KeyHolder keyHolder = new GeneratedKeyHolder();

		jdbcTemplate.update(new PreparedStatementCreator() {
			@Override
			public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(sql, new String[] { "id" });
				ps.setLong(1, patient.getPsSite().getId());
				ps.setString(2, patient.getPatientAccount());
				ps.setString(3, patient.getPatientLastName());
				ps.setString(4, patient.getPatientFirstName());
				ps.setString(5, patient.getPatientMiddleName());
				ps.setString(6, patient.getAddress1());
				ps.setString(7, patient.getAddress2());
				ps.setString(8, patient.getAddress3());
				ps.setString(9, patient.getCity());
				ps.setString(10, patient.getState());
				ps.setString(11, patient.getZipCode());
				ps.setString(12, patient.getCountryName());
				ps.setDouble(13, patient.getAmountDue().getDouble());
				ps.setString(14, patient.getAmountDue().getCobol());
				ps.setDouble(15, patient.getPrevBalance().getDouble());
				ps.setString(16, patient.getPrevBalance().getCobol());
				ps.setDouble(17, patient.getTotalCharges().getDouble());
				ps.setString(18, patient.getTotalCharges().getCobol());
				ps.setDouble(19, patient.getTotalCredits().getDouble());
				ps.setString(20, patient.getTotalCredits().getCobol());
				ps.setDouble(21, patient.getNewBalance().getDouble());
				ps.setString(22, patient.getNewBalance().getCobol());
				ps.setString(23, patient.getSpecialNotes());
				ps.setString(24, patient.getSpecialNotesForLateSites1());
				ps.setString(25, patient.getSpecialNotesForLateSites2());
				ps.setString(26, patient.getRightsObligationParagraphCodes());
				ps.setInt(27, patient.getNumOfLines());
				ps.setLong(28, patient.getDfnNumber());
				ps.setString(29, patient.getLargeFontInd().toString());
				ps.setString(30, patient.getIcnNumber());
				ps.setString(31, patient.getAddressFlag().toString());
				// Null is allowed.
				if (patient.getLastBillPrepDate() == null) {
					ps.setDate(32, null);
				} else {
					ps.setDate(32, new Date(patient.getLastBillPrepDate().getTime()));
				}
				return ps;
			}
		}, keyHolder);
		patient.setId(keyHolder.getKey().longValue());

		// Load the new audit fields and set on statement
		cbssAuditDatesDAO.getAuditDates("PSPatient", patient.getId(), patient);

		return patient.getId();
	}

}
