package gov.va.cpss.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.cobol.Money;
import gov.va.cpss.model.BooleanChar;
import gov.va.cpss.model.cbs.CBSStmt;

/**
 * 
 * Map row from CBSStmt table to CBSStmt object
 * 
 * @author Brad Pickle
 *
 */
public class CBSStmtRowMapper implements RowMapper<CBSStmt> {

	@Override
	public CBSStmt mapRow(ResultSet rs, int rowNum) throws SQLException {
		CBSStmt cbsStmt = new CBSStmt(rs.getLong("accountId"));
		
		cbsStmt.setId(rs.getLong("id"));
		cbsStmt.setReplacedStmtId(rs.getLong("replacedStmtId"));
		cbsStmt.setMessageId(rs.getLong("messageId"));
		cbsStmt.setAcntNumDisp(rs.getString("acntNumDisp"));
		cbsStmt.setAmountDue(new Money(rs.getDouble("amountDue"), 9));
		cbsStmt.setPrevBalance(new Money(rs.getDouble("prevBalance"), 9));
		cbsStmt.setTotalCharges(new Money(rs.getDouble("totalCharges"), 9));
		cbsStmt.setTotalCredits(new Money(rs.getDouble("totalCredits"), 9));
		cbsStmt.setNewBalance(new Money(rs.getDouble("newBalance"), 9));
		cbsStmt.setLateStmtMsg(BooleanChar.from(rs.getString("lateStmtMsg")).isTrue());
		cbsStmt.setStatementDate(rs.getDate("statementDate"));
		cbsStmt.setProcessDate(rs.getDate("processDate"));
		cbsStmt.setBatchRunId(rs.getLong("batchRunId"));
		cbsStmt.setStatusId(rs.getInt("statusId"));
		cbsStmt.setCreatedBy(rs.getString("createdBy"));
		cbsStmt.setCreatedDate(rs.getDate("createdDate"));
		cbsStmt.setModifiedBy(rs.getString("modifiedBy"));
		cbsStmt.setModifiedDate(rs.getDate("modifiedDate"));
        		
		return cbsStmt;
	}

}
