package gov.va.cpss.dao.impl;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.log4j.Logger;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;

import gov.va.cpss.model.cbs.CBSSiteTrans;

/**
 * Custom ItemPreparedStatementSetter for JdbcBatchItemWriter to set values in
 * prepared statement for batch data insert into the CBSSiteTrans table.
 * 
 * @author DNS 
 */
public class CBSSiteTransItemPreparedStatementSetter implements ItemPreparedStatementSetter<CBSSiteTrans> {

	private final Logger setterLogger;

	public CBSSiteTransItemPreparedStatementSetter() {
		setterLogger = Logger.getLogger(this.getClass().getCanonicalName());
	}

	@Override
	public void setValues(CBSSiteTrans arg0, PreparedStatement arg1) throws SQLException {

		setterLogger.debug("Setting values to insert CBSSiteTrans row");

		arg1.setLong(1, arg0.getSiteStmtId());
		if (arg0.getDatePosted() != null) {
			arg1.setDate(2, new Date(arg0.getDatePosted().getTime()));
		} else {
			arg1.setDate(2, null);
		}
		arg1.setString(3, arg0.getTransDesc());
		arg1.setDouble(4, arg0.getTransAmount().getDouble());
		arg1.setString(5, arg0.getTransAmount().getCobol());
		arg1.setString(6, arg0.getReferenceNum());
		arg1.setLong(7, arg0.getOrderNum());
	}

}
