package gov.va.cpss.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.cobol.Money;
import gov.va.cpss.model.BooleanChar;
import gov.va.cpss.model.cbs.CBSSiteStmt;

/**
 * 
 * Map row from CBSSiteStmt table to CBSSiteStmt object
 * 
 * @author Brad Pickle
 *
 */
public class CBSSiteStmtRowMapper implements RowMapper<CBSSiteStmt> {

	@Override
	public CBSSiteStmt mapRow(ResultSet rs, int rowNum) throws SQLException {
		CBSSiteStmt cbsSiteStmt = new CBSSiteStmt();
		
		cbsSiteStmt.setId(rs.getLong("id"));
		cbsSiteStmt.setStmtId(rs.getLong("stmtId"));
		cbsSiteStmt.setStationNum(rs.getString("stationNum"));
		cbsSiteStmt.setStationPhoneNum(rs.getString("stationPhoneNum"));
		cbsSiteStmt.setProcessDate(rs.getDate("processDate"));
		cbsSiteStmt.setStatementDate(rs.getDate("statementDate"));
		cbsSiteStmt.setAmountDue(new Money(rs.getDouble("amntDue"), 9));
		cbsSiteStmt.setPrevBalance(new Money(rs.getDouble("preBalance"), 9));
		cbsSiteStmt.setTotalCharges(new Money(rs.getDouble("totalCharges"), 9));
		cbsSiteStmt.setTotalCredits(new Money(rs.getDouble("totalCredits"), 9));
		cbsSiteStmt.setNewBalance(new Money(rs.getDouble("newBalance"), 9));
		cbsSiteStmt.setSpecialNotes(rs.getString("specialNotes"));
		cbsSiteStmt.setNoParaCdes(rs.getString("noParaCdes"));
		cbsSiteStmt.setLargeFontInd(BooleanChar.from(rs.getString("largeFontInd")));
		cbsSiteStmt.setArAddressFlag(BooleanChar.from(rs.getString("arAddressFlag")));
		cbsSiteStmt.setLastBillPrepDate(rs.getDate("lastBillPrepDate"));
		cbsSiteStmt.setIsPrimary(BooleanChar.from(rs.getString("isPrimary")));
		cbsSiteStmt.setIsPrimaryAddress(BooleanChar.from(rs.getString("isPrimaryAddress")));
		cbsSiteStmt.setCreatedBy(rs.getString("createdBy"));
		cbsSiteStmt.setCreatedDate(rs.getDate("createdDate"));
		cbsSiteStmt.setModifiedBy(rs.getString("modifiedBy"));
		cbsSiteStmt.setModifiedDate(rs.getDate("modifiedDate"));
		        		
		return cbsSiteStmt;
	}

}
