package gov.va.cpss.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import javax.sql.DataSource;

import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.dao.CBSSAuditDatesDAO;
import gov.va.cpss.model.CBSSAuditDates;

/**
 * An implementation of the CBSSAuditDatesDAO interface.
 * 
  * @author Brad Pickle
*/
public class CBSSAuditDatesDAOImpl implements CBSSAuditDatesDAO {

    @SuppressWarnings("unused")
	private final Logger daoLogger;

    private JdbcTemplate jdbcTemplate;

    public CBSSAuditDatesDAOImpl() {
        daoLogger = Logger.getLogger(this.getClass().getCanonicalName());
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

	@Override
	public CBSSAuditDates getAuditDates(String cbssTableName, long recordId, final CBSSAuditDates auditDatesRecord) {
		final String sql = "SELECT createdBy, createdDate, modifiedBy, modifiedDate FROM " + cbssTableName + " WHERE id = " + recordId;
		
        List<CBSSAuditDates> cbssAuditDatesL = jdbcTemplate.query(sql, new RowMapper<CBSSAuditDates>() {

            @Override
            public CBSSAuditDates mapRow(ResultSet rs, int rowNum) throws SQLException {
            	CBSSAuditDates returnAuditDatesRecord = (auditDatesRecord != null) ? auditDatesRecord : new CBSSAuditDates() {
            		
            		String createdBy;
            		Date createdDate;
            		String modifiedBy;
            		Date modifiedDate;

					@Override
					public String getCreatedBy() {
						return createdBy;
					}

					@Override
					public void setCreatedBy(String createdBy) {
						this.createdBy = createdBy;
					}

					@Override
					public Date getCreatedDate() {
						return createdDate;
					}

					@Override
					public void setCreatedDate(Date createdDate) {
						this.createdDate = createdDate;
					}

					@Override
					public Date getModifiedDate() {
						return modifiedDate;
					}

					@Override
					public void setModifiedDate(Date modifiedDate) {
						this.modifiedDate = modifiedDate;
					}

					@Override
					public String getModifiedBy() {
						return modifiedBy;
					}

					@Override
					public void setModifiedBy(String modifiedBy) {
						this.modifiedBy = modifiedBy;
					}
            		
            	};
            	
            	returnAuditDatesRecord.setCreatedBy(rs.getString("createdBy"));
            	returnAuditDatesRecord.setCreatedDate(new java.util.Date(rs.getDate("createdDate").getTime()));
            	returnAuditDatesRecord.setModifiedBy(rs.getString("modifiedBy"));
            	returnAuditDatesRecord.setModifiedDate(new java.util.Date(rs.getDate("modifiedDate").getTime()));

                return returnAuditDatesRecord;
            }

        });
        
        CBSSAuditDates returnVal = auditDatesRecord;
        if (cbssAuditDatesL.size() > 0) {
        	returnVal = cbssAuditDatesL.get(0);
        }
        
        return returnVal;
	}

}
