package gov.va.cpss.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

import gov.va.cpss.dao.CBSPatAcntBalMsgDAO;
import gov.va.cpss.dao.CBSSAuditDatesDAO;
import gov.va.cpss.model.bal.PatAcntBalMsg;

public class CBSPatAcntBalMsgDAOImpl implements CBSPatAcntBalMsgDAO {
	private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
	private CBSSAuditDatesDAO cbssAuditDatesDAO;
	private JdbcTemplate jdbcTemplate;
	public void setDataSource(DataSource dataSource) {
		this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}
	

	@Override
	public List<PatAcntBalMsg> getCBSPatAcntBalMsgInStatus(int statusId) {
		final String sql = "SELECT * FROM PATACNTBALMSG WHERE statusId = " + statusId + " order by id";

		final List<PatAcntBalMsg> patAcntBalMsgs = namedParameterJdbcTemplate.query(sql, new CBSPatAcntBalMsgRowMapper());
		return patAcntBalMsgs;
	}


	@Override
	public PatAcntBalMsg get(long id) {
			final String sql = "SELECT * FROM PATACNTBALMSG WHERE id = " + id;

			final List<PatAcntBalMsg> patAcntBalMsg = namedParameterJdbcTemplate.query(sql, new CBSPatAcntBalMsgRowMapper());

			return (patAcntBalMsg.size() > 0) ? patAcntBalMsg.get(0) : null;
		}
	

	@Override
	public void update(PatAcntBalMsg patAcntBalMsg) {
		final String sql = "UPDATE PATACNTBALMSG " + "SET batchRunId=:batchRunId, statusId=:statusId, fileName=:fileName "
				+ "WHERE id=:id";

		namedParameterJdbcTemplate.update(sql, new BeanPropertySqlParameterSource(patAcntBalMsg));

		// Load the new audit fields and set on cbsMessage
		cbssAuditDatesDAO.getAuditDates("PATACNTBALMSG", patAcntBalMsg.getId(), patAcntBalMsg);
	}
	@Override
	public long insert(PatAcntBalMsg patAcntBalMsg) {
		// insert
				final String sql = "INSERT INTO PATACNTBALMSG (batchRunId, fileName, statusId,  totNumPatient) "
						+ "VALUES (:batchRunId, :fileName, :statusId, :totNumPatient)";
				final KeyHolder keyHolder = new GeneratedKeyHolder();

				namedParameterJdbcTemplate.update(sql, new BeanPropertySqlParameterSource(patAcntBalMsg), keyHolder,
						new String[] { "id" });
				patAcntBalMsg.setId(keyHolder.getKey().intValue());

				// Load the new audit fields and set on cbsMessage
				cbssAuditDatesDAO.getAuditDates("PATACNTBALMSG", patAcntBalMsg.getId(), patAcntBalMsg);

				return patAcntBalMsg.getId();
			}
	public List<PatAcntBalMsg> getPatAcntBalMsgInStatus(int statusId) {
		final String sql = "SELECT * FROM PATACNTBALMSG WHERE statusId = " + statusId + " order by id";

		final List<PatAcntBalMsg> patAcntBalMsgs = namedParameterJdbcTemplate.query(sql, new CBSPatAcntBalMsgRowMapper());

		return patAcntBalMsgs;
	}

	/**
	 * @param cbssAuditDatesDAO the cbssAuditDatesDAO to set
	 */
	public void setCbssAuditDatesDAO(CBSSAuditDatesDAO cbssAuditDatesDAO) {
		this.cbssAuditDatesDAO = cbssAuditDatesDAO;
	}

	public void updateTotalPatients(Long totNumPatient, Long id) {	
		String sql = "UPDATE PATACNTBALMSG SET totNumPatient=? WHERE id=?";
		System.out.println("TotNumPatient" + totNumPatient.longValue() + "ID is:" + id.longValue());
        jdbcTemplate.update(sql, totNumPatient.longValue(), id.longValue());
	}
	
	private class CBSPatAcntBalMsgRowMapper implements RowMapper<PatAcntBalMsg> {

		@Override
		public PatAcntBalMsg mapRow(ResultSet rs, int rowNum) throws SQLException {
			PatAcntBalMsg patAcntBalMsg = new PatAcntBalMsg();

			patAcntBalMsg.setId(rs.getLong("id"));
			patAcntBalMsg.setBatchRunId(rs.getLong("batchRunId"));
			patAcntBalMsg.setStatusId(rs.getInt("statusId"));
			patAcntBalMsg.setFileName(rs.getString("fileName"));
			patAcntBalMsg.setCreatedBy(rs.getString("createdBy"));
			patAcntBalMsg.setCreatedDate(new java.util.Date(rs.getDate("createdDate").getTime()));
			patAcntBalMsg.setModifiedBy(rs.getString("modifiedBy"));
			patAcntBalMsg.setModifiedDate(new java.util.Date(rs.getDate("modifiedDate").getTime()));
			patAcntBalMsg.setTotNumPatient(rs.getLong("totNumPatient"));

			return patAcntBalMsg;
		}
		
	}

}
