package gov.va.cpss.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.dao.BatchTypeDAO;
import gov.va.cpss.model.BatchType;
import static gov.va.cpss.ESAPI.EsapiValidator.validateStringInput;
import static gov.va.cpss.ESAPI.EsapiValidationType.LOG_FORGING;
/**
 * An implementation of the BatchTypeDAO interface.
 */
public class BatchTypeDAOImpl implements BatchTypeDAO {

    private final Logger daoLogger;

    private JdbcTemplate jdbcTemplate;

    private Map<Integer, BatchType> idToTypeM;

    // Constructor.
    public BatchTypeDAOImpl() {

        daoLogger = Logger.getLogger(this.getClass().getCanonicalName());

        idToTypeM = new HashMap<>();
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public void initTypeMaps() {

        List<BatchType> bTL = batchTypeList();

        for (BatchType bT : bTL) {
            BatchType.JobType enumValue = BatchType.JobType.lookupByName(bT.getName());
            if (enumValue == null) {
                daoLogger.error("Unrecognized batch type in database: " + validateStringInput(bT.getName(), LOG_FORGING));
            } else {
                bT.setJobType(enumValue);
            }
            idToTypeM.put(bT.getId(), bT);
        }
    }

    @Override
    public List<BatchType> batchTypeList() {
        String sql = "SELECT * FROM batchtype";
        List<BatchType> batchL = jdbcTemplate.query(sql, new RowMapper<BatchType>() {

            @Override
            public BatchType mapRow(ResultSet rs, int rowNum) throws SQLException {
                BatchType batchType = new BatchType();

                batchType.setId(rs.getInt("id"));
                batchType.setName(rs.getString("name"));
                batchType.setDescription(rs.getString("description"));

                return batchType;
            }

        });

        return batchL;
    }

    @Override
    public BatchType getBatchType(int id) {

        return idToTypeM.get(id);
    }

}
