package gov.va.cpss.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.dao.BatchSrcTypeDAO;
import gov.va.cpss.model.BatchSrcType;
import static gov.va.cpss.ESAPI.EsapiValidator.validateStringInput;
import static gov.va.cpss.ESAPI.EsapiValidationType.LOG_FORGING;

public class BatchSrcTypeDAOImpl implements BatchSrcTypeDAO {

	private final Logger daoLogger;
	
	private JdbcTemplate jdbcTemplate;
	
	private Map<Integer, BatchSrcType> idToTypeM;
	
	// Constructor.
	public BatchSrcTypeDAOImpl() {
		
		daoLogger = Logger.getLogger(this.getClass().getCanonicalName());
		
		idToTypeM = new HashMap<>();
	}
	
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}
	
	@Override
	public void initTypeMaps() {
		
		List<BatchSrcType> bSTL = batchSrcTypeList();
		
		for (BatchSrcType bST : bSTL){
			BatchSrcType.SrcType enumValue = BatchSrcType.SrcType.lookupByName(bST.getName());
			if (enumValue == null) {
				daoLogger.error("Unrecognized batch source type in database: " + validateStringInput(bST.getName(), LOG_FORGING));
			} else {
				bST.setSrcType(enumValue);
			}
			idToTypeM.put(bST.getId(), bST);
		}
	}

	@Override
	public List<BatchSrcType> batchSrcTypeList() {
		String sql = "SELECT * FROM batchsrctype";
		List<BatchSrcType> batchL = jdbcTemplate.query(sql, new RowMapper<BatchSrcType>() {
			
			@Override
			public BatchSrcType mapRow(ResultSet rs, int rowNum) throws SQLException {
				BatchSrcType batchSrcType = new BatchSrcType();
				
				batchSrcType.setId(rs.getInt("id"));
				batchSrcType.setName(rs.getString("name"));
				batchSrcType.setDescription(rs.getString("description"));
				
				return batchSrcType;
			}
			
		});
		
		return batchL;
		
	}
}
