package gov.va.cpss.dao.impl;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.dao.BatchRunProcessDAO;

import gov.va.cpss.model.BatchRunProcess;
import gov.va.cpss.model.CBSSAbstractModel;

/**
 * 
 * The DAO implementation for Batch Run Process table.
 * 
 * Copyright HPE / VA
 * February 14, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
@SuppressWarnings("nls")
public class BatchRunProcessDAOImpl extends CBSSBaseDAOImpl implements BatchRunProcessDAO
{
    final public static String TABLE_NAME = "BatchRunProcess";

    @Override
    public void updateStatus(BatchRunProcess process)
    {
        final String sql = "UPDATE " + TABLE_NAME + " SET statusId = ?, other = ? where id = ?";

        this.jdbcTemplate.update(sql, Integer.valueOf(process.getStatusId()), process.getOther(), Long.valueOf(process.getId()));
    }


    @Override
    public long insert(BatchRunProcess brp) {
        return save(brp);
    }

    @Override
    public void update(BatchRunProcess brp) {
        String sql = "UPDATE BatchRunProcess SET batchRunId=?, fileName=?, processDate=?, other=?, statusId=? WHERE id=?";
        this.jdbcTemplate.update(sql, Long.valueOf(brp.getBatchRunId()), brp.getFileName(), brp.getProcessDate(), brp.getOther(), Integer.valueOf(brp.getStatusId()), brp.getId());
    }

    @Override
    public BatchRunProcess getByBatchRunId(int batchRunId) {
        String sql = "SELECT * FROM (SELECT * FROM batchRunProcess WHERE batchRunId=" + batchRunId + " ORDER BY id DESC) WHERE rownum <= 1";
        return this.jdbcTemplate.query(sql, new ResultSetExtractor<BatchRunProcess>() {

            @Override
            public BatchRunProcess extractData(ResultSet rs) throws SQLException {
                if(rs.next()) {
                    return (BatchRunProcess) mapResult(rs);                 
                }
                
                return null;
            }
        });
    }
    
    @Override
    public BatchRunProcess get(long id) {
        final String sql = "SELECT * FROM BatchRunProcess WHERE ID="+id;

        final List<BatchRunProcess> batchRunProcessL = this.jdbcTemplate.query(sql, new RowMapper<BatchRunProcess>() {

            @Override
            public BatchRunProcess mapRow(ResultSet rs, int rowNum) throws SQLException {
                return (BatchRunProcess) mapResult(rs);
            }
            
        });
        
        return (batchRunProcessL.size() > 0) ? batchRunProcessL.get(0) : null;
    }
    
    @Override
    public int updateStatus(final List<Long> batchRunProcessIdList, final int statusId) {
        if((batchRunProcessIdList == null) || (batchRunProcessIdList.size() == 0))
            return 0;
        
        final String sql = "UPDATE BatchRunProcess SET statusId = " + statusId + "where id=?";
        
        int numRowsUpdated = 0;
        for(int i = 0; i < batchRunProcessIdList.size(); i++) {
            numRowsUpdated += this.jdbcTemplate.update(sql, batchRunProcessIdList.get(i));
        }
        
        return numRowsUpdated;
    }

	@Override
	public List<BatchRunProcess> getBatchRunProcessesInStatus(int statusId) {
		String sql = "SELECT * FROM BatchRunProcess WHERE statusId = " + statusId;
		
		final List<BatchRunProcess> batchRunProcesses = jdbcTemplate.query(sql, new RowMapper<BatchRunProcess>() {

			@Override
			public BatchRunProcess mapRow(ResultSet rs, int rowNum) throws SQLException {

				return (BatchRunProcess) mapResult(rs);
			}
		});

		return batchRunProcesses;
	}

    /* (non-Javadoc)
     * @see gov.va.cpss.dao.impl.CBSSBaseDAOImpl#getTableName()
     */
    @Override
    public String getTableName()
    {
        return TABLE_NAME;
    }

    /* (non-Javadoc)
     * @see gov.va.cpss.dao.impl.CBSSBaseDAOImpl#getInsertSQL()
     */
    @Override
    public String getInsertSQL()
    {
        return  "INSERT INTO " + TABLE_NAME +
                " (batchRunId, fileName, processDate, other, statusId) " +
                " VALUES (?, ?, ?, ?, ?)";
    }

    /* (non-Javadoc)
     * @see gov.va.cpss.dao.impl.CBSSBaseDAOImpl#mapResult(java.sql.ResultSet)
     */
    @Override
    protected CBSSAbstractModel mapResult(ResultSet rs) throws SQLException
    {
        BatchRunProcess process = new BatchRunProcess();

        process.setId(rs.getLong("id"));
        process.setBatchRunId(rs.getLong("batchRunId"));
        process.setFileName(rs.getString("fileName"));
        process.setProcessDate(rs.getDate("processDate"));
        process.setOther(rs.getString("other"));
        process.setStatusId(rs.getInt("statusId"));

        return process;
    }

    /* (non-Javadoc)
     * @see gov.va.cpss.dao.impl.CBSSBaseDAOImpl#mapRows(java.sql.PreparedStatement, gov.va.cpss.model.CBSSAbstractModel)
     */
    @Override
    protected void mapRows(PreparedStatement ps, CBSSAbstractModel model) throws SQLException
    {
        BatchRunProcess process = (BatchRunProcess) model;

        ps.setLong(1, process.getBatchRunId());
        ps.setString(2, process.getFileName());
        ps.setDate(3, new Date(process.getProcessDate().getTime()));
        ps.setString(4, process.getOther());
        ps.setInt(5, process.getStatusId());
    }

}
