package gov.va.cpss.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

import gov.va.cpss.dao.BatchConfigDAO;
import gov.va.cpss.model.BatchConfig;
import gov.va.cpss.model.BatchJob;

/**
 * An implementation of the BatchConfigDAO interface.
 */
public class BatchConfigDAOImpl implements BatchConfigDAO {

    private JdbcTemplate jdbcTemplate;

	public BatchConfigDAOImpl() {
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public BatchConfig getBatchConfig(int id) {
        String sql = "SELECT * FROM batchconfig where batchjobid = " + id;
        return jdbcTemplate.query(sql, new ResultSetExtractor<BatchConfig>() {

            @Override
            public BatchConfig extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    BatchConfig batchConfig = new BatchConfig();
                    batchConfig.setBatchJobId(rs.getInt("batchjobid"));
                    batchConfig.setRangeStart(rs.getDate("rangestart"));
                    batchConfig.setRangeEnd(rs.getDate("rangeend"));
                    batchConfig.setOther(rs.getString("other"));
                    return batchConfig;
                }
                return null;
            }
        });
    }

    private void update(BatchJob batchJob) {
        // update
		String sql = "UPDATE batchconfig SET rangestart=?, rangeend=?, other=? WHERE batchjobid=?";
       jdbcTemplate.update(sql, batchJob.getBatchConfig().getRangeStart(),
        		batchJob.getBatchConfig().getRangeEnd(), batchJob.getBatchConfig().getOther(), batchJob.getId());
    }
    
    private void insert(BatchJob batchJob) {
        // insert
		String sql = "INSERT into batchconfig (batchjobid, rangestart, rangeend, other) values (?, ?, ?, ?)";
       jdbcTemplate.update(sql, batchJob.getId(), batchJob.getBatchConfig().getRangeStart(),
        		batchJob.getBatchConfig().getRangeEnd(), batchJob.getBatchConfig().getOther());
    }
    
    @Override
    public void updateOrInsert(BatchJob batchJob) {
        // if the batchjob has never had a configuration before insert 
    	// otherwise update existing
		BatchConfig batchConfig = getBatchConfig(batchJob.getId());
		if(batchConfig == null){
			insert(batchJob);
		}else{
			update(batchJob);
		}
    }
}
