package gov.va.cpss.dao.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

import java.util.List;

import gov.va.cpss.dao.APSReceivedSiteDAO;

import gov.va.cpss.model.CBSSAbstractModel;
import gov.va.cpss.model.apps.APSReceivedSite;

/**
 * 
 * An implementation of the APSReceivedSiteDAO interface.
 * 
 * Copyright DXC / VA
 * April 24, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
@SuppressWarnings("nls")
public class APSReceivedSiteDAOImpl extends CBSSBaseDAOImpl implements APSReceivedSiteDAO
{
    final public static String TABLE_NAME = "APSReceivedSite";

    @SuppressWarnings("unchecked")
    @Override
    public List<APSReceivedSite> select(final String facilityNumber, final int statementYear)
    {
        final String whereClause = "WHERE stationNum = ? AND statementYear = ?";

        return (List<APSReceivedSite>) select(whereClause, null, new Object[]{facilityNumber, Integer.valueOf(statementYear)});
    }

    @Override
    public int update(final long id, final long numOfMessages, final int statusId)
    {
        final String sql = "UPDATE " + TABLE_NAME + " SET msgNum = ?, statusId = ? WHERE id = ?";

        return this.jdbcTemplate.update(sql, Long.valueOf(numOfMessages),
                                             Integer.valueOf(statusId),
                                             Long.valueOf(id));
    }

    @Override
    public String getTableName()
    {
        return TABLE_NAME;
    }

    @Override
    public String getInsertSQL()
    {
        return "INSERT INTO " + TABLE_NAME + 
                " (stationNum, statementYear, receivedDate, msgNum, totMsgNum, statusId) " +
                "VALUES (?, ?, ?, ?, ?, ?)";
    }

    @Override
    protected void mapRows(PreparedStatement ps, CBSSAbstractModel model) throws SQLException
    {
        APSReceivedSite receivedSite = (APSReceivedSite) model;

        ps.setString(1, receivedSite.getFacilityNum());
        ps.setInt(2, getYear(receivedSite.getStatementDate()));
        ps.setTimestamp(3, new Timestamp(receivedSite.getReceivedDate().getTime()));
        ps.setLong(4, receivedSite.getNumOfMessages());
        ps.setLong(5, receivedSite.getTotMsgNum());
        ps.setInt(6, receivedSite.getStatusId());
    }

    @Override
    protected CBSSAbstractModel mapResult(ResultSet rs) throws SQLException
    {
        APSReceivedSite receivedSite = new APSReceivedSite();

        receivedSite.setId(rs.getLong(ID));
        receivedSite.setFacilityNum(rs.getString("stationNum"));
        receivedSite.setStatementDate(getDate(rs.getInt("statementYear")));
        receivedSite.setReceivedDate(new java.util.Date(rs.getTimestamp("receivedDate").getTime()));
        receivedSite.setNumOfMessages(rs.getLong("msgNum"));
        receivedSite.setTotMsgNum(rs.getLong("totMsgNum"));
        receivedSite.setStatusId(rs.getInt("statusId"));

        // Audit fields
        mapAuditFields(rs, receivedSite);

        return receivedSite;
    }
}
