package gov.va.cpss.dao.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.dao.APSReceivedDAO;

import gov.va.cpss.model.CBSSAbstractModel;
import gov.va.cpss.model.ProcessStatus.Status;
import gov.va.cpss.model.apps.APSReceived;

/**
 * 
 * An implementation of the APSReceivedDAO interface.
 * 
 * Copyright HPE / VA
 * October 27, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
@SuppressWarnings("nls")
public class APSReceivedDAOImpl extends CBSSBaseDAOImpl implements APSReceivedDAO
{
    final public static String TABLE_NAME = "APSReceived";

	@Override
	public int updateResults(final APSReceived apsReceived)
	{
		final String sql = "UPDATE APSReceived SET statusId = ?, numOfSite = ?, numOfPatient = ? WHERE id = ?";

		return this.jdbcTemplate.update(sql, Integer.valueOf(apsReceived.getStatusId()),
		                                     Long.valueOf(apsReceived.getNumOfSite()),
		                                     Long.valueOf(apsReceived.getNumOfPatient()),
		                                     Long.valueOf(apsReceived.getId()));
	}

	@Override
	public List<Long> getAPSReceivedIdListByStatus(final Status status)
	{
		String sql = "SELECT id FROM APSReceived WHERE statusId = ?" + ORDER_BY_ID_CLAUSE;

		List<Long> ids = this.jdbcTemplate.query(sql, new PreparedStatementSetter()
		{
			@Override
            public void setValues(PreparedStatement preparedStatement) throws SQLException
			{
				preparedStatement.setInt(1, getStatusID(status));
			}
		},
		new RowMapper<Long>()
	    {
		    @Override
		    public Long mapRow(ResultSet rs, int rowNum) throws SQLException
		    {
		        Long id = Long.valueOf(rs.getLong(ID));
		        return id;
		    }
	    });

		return ids;
	}

    @Override
    public String getTableName()
    {
        return TABLE_NAME;
    }

    @Override
    public String getInsertSQL()
    {
        return "INSERT INTO " + TABLE_NAME + 
                "(numOfSite, numOfPatient, dateReceived, statusId, fileName, batchRunId) " +
                "VALUES (?, ?, ?, ?, ?, ?)";
    }

    @Override
    protected void mapRows(PreparedStatement ps, CBSSAbstractModel model) throws SQLException
    {
        APSReceived apsReceived = (APSReceived) model;

        ps.setLong(1, apsReceived.getNumOfSite());
        ps.setLong(2, apsReceived.getNumOfPatient());
        ps.setTimestamp(3, new Timestamp(apsReceived.getDateReceived().getTime()));
        ps.setInt(4, apsReceived.getStatusId());
        ps.setString(5, apsReceived.getFileName());
        ps.setInt(6, apsReceived.getBatchRunId());
    }

    @Override
    protected CBSSAbstractModel mapResult(ResultSet rs) throws SQLException
    {
        return null;
    }
}
