package gov.va.cpss.dao.impl;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Month;
import java.util.List;

import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.dao.APSPaymentDAO;
import gov.va.cpss.model.AITCDollar;
import gov.va.cpss.model.CBSSAbstractModel;

import gov.va.cpss.model.apps.APSPayment;

/**
 * An implementation of the APSPaymentDAO interface.
 * 
 * Copyright HPE / VA
 * January 18, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
*/
@SuppressWarnings("nls")
public class APSPaymentDAOImpl extends CBSSBaseDAOImpl implements APSPaymentDAO
{
    public static final String TABLE_NAME = "APSPayment";
    
    private class APSPaymentRowMapper implements RowMapper<APSPayment>
    {
        public APSPaymentRowMapper()
        {
            // Default constructor.
        }

        @Override
        public APSPayment mapRow(ResultSet rs, int rowNum) throws SQLException
        {
            return (APSPayment) mapResult(rs);
        }
        
    }

    @Override
    public List<APSPayment> getPaymentsForSiteStmt(long siteStmtId) {
        final String sql = "SELECT * FROM APSPayment WHERE siteStmtid=" + siteStmtId + " ORDER BY datePosted ASC";
        
        return this.jdbcTemplate.query(sql, new APSPaymentRowMapper());
    }


    @Override
    public String getTableName()
    {
        return TABLE_NAME;
    }

    @Override
    public String getInsertSQL()
    {
        return  "INSERT " + PARALLEL_HINT + " INTO " + TABLE_NAME +
                " (siteStmtId, month, datePosted, transAmnt, transAmntRaw) " +
                " VALUES (?, ?, ?, ?, ?)";
    }

    @Override
    protected void mapRows(PreparedStatement ps, CBSSAbstractModel model) throws SQLException
    {
        APSPayment payment = (APSPayment) model;

        ps.setLong(1, payment.getSiteStmtId());
        ps.setInt(2, payment.getMonth().getValue());
        ps.setDate(3, new Date(payment.getDatePosted().getTime()));
        ps.setDouble(4, payment.getTransactionAmount().getDouble());
        ps.setString(5, payment.getTransactionAmountStr());
    }

    @Override
    protected CBSSAbstractModel mapResult(ResultSet rs) throws SQLException
    {
        APSPayment payment = new APSPayment();

        payment.setId(rs.getLong(ID));
        payment.setSiteStmtId(rs.getLong("siteStmtId"));
        payment.setMonth(Month.of(rs.getInt("month")));
        payment.setDatePosted((rs.getDate("datePosted") == null) ? null : new Date(rs.getDate("datePosted").getTime()));
        payment.setTransactionAmount(new AITCDollar(rs.getDouble("transAmnt")));
        payment.setTransactionAmountStr(rs.getString("transAmntRaw"));

        // Audit fields
        mapAuditFields(rs, payment);

        return payment;
    }

}
