package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.ProcessStatus.Status;
import gov.va.cpss.model.icn.VistaAcntHist;

/**
 *
 * VistA Account History DAO Interface.
 *
 * Sprint 5 - Epic 349068, Task 370262 DAO Implementation.
 *
 * Copyright HPE / VA
 * August 29, 2016
 *
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
public interface VistaAcntHistDAO extends CBSSBaseDAO
{
	/**
	 * Select Vista Account History based on the DFN and Station Number
	 *
	 * @param dfn
	 * @param stationNum
	 * @return list of VistaAcntHist that meets the criteria.
	 */
	public List<VistaAcntHist> selectByDfnSite(final long dfn, final String stationNum);

	/**
	 * Select VistA Account History based on the status
	 *
	 * @param statusID
	 * @return list of VistaAcntHist that meets the status criteria.
	 */
	public List<VistaAcntHist> select(final int statusID);

	/**
	 * Select VistA Account History based on the status
	 *
	 * @param inStatus
	 * @return list of VistaAcntHist that meets the status criteria.
	 */
	public List<VistaAcntHist> select(final Status inStatus);

	/**
	 * Update VistA Account History with the status
	 *
	 * @param inIDs
	 * @param statusID
	 * @return the numbers of updated rows.
	 */
	public int[] update(final long[] inIDs, final int statusID);

	/**
	 * Update VistA Account History with the status
	 *
	 * @param inIDs
	 * @param inStatus
	 * @return the numbers of updated rows.
	 */
	// Already in Base Interface
	//public int[] update(final long[] inIDs, final Status inStatus);

	/**
	 * Update VistA Account History with the status
	 *
	 * @param inVistaAcntHistories
	 * @param inStatus
	 * @return the numbers of updated rows.
	 */
	public int[] update(final List<VistaAcntHist> inVistaAcntHistories, final Status inStatus);

	/**
	 * Update VistA Account History with the status
	 *
	 * @param inVistaAcntHistories
	 * @return the numbers of updated rows.
	 */
	public int[] update(final List<VistaAcntHist> inVistaAcntHistories);

	/**
	 * Batch update
	 *
	 * @param inDFNs
	 * @param inStationNumbers
	 * @param inNewICNs
	 * @param inOldICNs
	 * @return numbers of inserts
	 */
	public int[] batchInsert(final Long[] inDFNs, final String[] inStationNumbers, final String[] inNewICNs, final String[] inOldICNs);
}
