package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.ProcessStatus;

/**
 * Data Access Object interface for the ProcessStatus table.
 * 
 * @author DNS 
 */
public interface ProcessStatusDAO {

	/**
	 * Initialize the lookup mappings to correlate enumeration and data values
	 * in the database.
	 */
	public void initTypeMaps();

	/**
	 * Get a list of status from the database.
	 * 
	 * @return List of ProcessStatus from the database.
	 */
	public List<ProcessStatus> statusTypeList();

	/**
	 * Get a status type from the specified ID.
	 * 
	 * @param id
	 *            Status ID data value associated with the database record.
	 * @return ProcessStatus object associated with the ID value.
	 */
	public ProcessStatus getStatusType(int id);

	/**
	 * Get a ProcessStatus from the specified enumeration.
	 * 
	 * @param enumValue
	 *            Status enum value.
	 * @return ProcessStatus object associated with the enumerated value.
	 */
	public Integer getStatusFromEnum(ProcessStatus.Status enumValue);

}
