package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.printack.PrintAckRec;

/**
 * Data Access Object interface for the PrintAckRec table.
 * 
 * @author Brad Pickle
 */
public interface PrintAckRecDAO {

	/**
	 * Save the specified PrintAckRec object in the database.
	 * 
	 * @param printAckRec
	 * @return The primary key ID value of the inserted entry.
	 */
	public long insert(PrintAckRec printAckRec);

	/**
	 * Update the status of the specified PrintAckRec object in the database.
	 * 
	 * @param printAckRec
	 */
	public void updateStatus(PrintAckRec printAckRec);

	/**
	 * Update the status in the database for each PrintAckRec record id in the
	 * given List to the given statusId.
	 * 
	 * @param printAckRecIdList
	 *            List of PrintAckRec record ids to update in the database.
	 * @param statusId
	 *            status id to update to.
	 * @return The number of rows updated.
	 */
	int updateStatus(List<Long> printAckRecIdList, int statusId);

	/**
	 * Get PrintAckRec with the given id
	 * 
	 * @param id
	 *            id of the PrintAckRec to get
	 * @return PrintAckRec with given id
	 */
	PrintAckRec get(long id);

}
