package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.fps.PSSite;

/**
 * Data Access Object interface for the PSSite table.
 * 
 * @author DNS   
 */
public interface PSSiteDAO {

	/**
	 * Save the specified PSSite to the database.
	 * 
	 * @param site
	 *            The site to save. The id, createdBy, createdDate, modifiedBy
	 *            and modifiedDate properties will be updated to match the
	 *            database state after the insert.
	 * @return Auto-generated index ID of the entry in the database.
	 */
	public long save(PSSite site);

	/**
	 * Get the index of the last entry in the table.
	 * 
	 * @return Long representation of the last index or null if none.
	 */
	public Long getLastIndex();

	/**
	 * Delete the entry in the table associated with the specified received ID.
	 * 
	 * @param receivedId
	 */
	public void deleteByReceivedId(final long receivedId);

	/**
	 * Get the site by the id.
	 * 
	 * @param id
	 */
	public PSSite getById(final long id);
	
	
	/**
	 * Get a list of all site for all PSReceived with given status.
	 * 
	 * @param statusId status id of PSReceived
	 * @return List<PSSite> unordered.
	 */
	public List<PSSite> getAllForPSReceivedStatusId(final int statusId);

	/**
	 * Get a list of all site by the specified received id.
	 */
	public List<PSSite> getAllByPSReceivedID(final long receivedId);

	/**
	 * Get a list of all site id by the specified list of received id.
	 */
	public List<Long> getAllIDByPSReceivedID(final long receivedId);
}
