package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.fps.PSReceived;

/**
 * Data Access Object interface for the PSReceived table.
 * 
 * @author DNS  
 */
public interface PSReceivedDAO {

	/**
	 * Save the specified PSReceived object in the database.
	 * 
	 * @param psReceived
	 * @return The primary key ID value of the inserted entry.
	 */
	public long save(PSReceived psReceived);

	/**
	 * Update the status of the specified PSReceived object in the database.
	 * 
	 * @param psReceived
	 */
	public void updateStatus(PSReceived psReceived);

	/**
	 * Update the results of the specified PSReceived object in the database.
	 * 
	 * @param psReceived
	 */
	public void updateResults(PSReceived psReceived);

	/**
	 * Get list of PSReceived ID that have the specified status.
	 * 
	 * @return The list of ID
	 */
	public List<Long> getPSReceivedIDListByStatusID(final int status);

	/**
	 * Update the PSReceived record with the specified status identified by the
	 * specified ID.
	 * 
	 * @param id
	 *            The id of the record.
	 * @param toStatus
	 *            The status to set.
	 * @return The number of rows updated.
	 */
	public int updateStatusById(final long id, final int toStatus);
}
