package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.fps.PSDetails;
import gov.va.cpss.model.fps.PSSite;

/**
 * Data Access Object interface for the PSDetails table.
 * 
 * @author DNS  
 */
public interface PSDetailsDAO {

    /**
     * Get the index of the last entry in the table.
     * @return Long representation of the last index or null if none.
     */
    public Long getLastIndex();
    
    /**
	 * Get a list of all details by the specified site.
	 */
	public List<PSDetails> getAllByPSSiteID(final PSSite psSite);

}
