package gov.va.cpss.dao;

import gov.va.cpss.model.CBSSAuditDates;

/**
 * Data Access Object interface for the cross table audit date fields.
 * 
 * @author Brad Pickle
 *
 */
public interface CBSSAuditDatesDAO {
	
	/**
	 * Gets the createdDate and modifiedDate fields for the record with the given recordId (id table field) from
	 * the given CBSS table and sets the values on the provided CBSSAuditDates object.
	 * @param cbssTableName	the name of the CBSS table to query
	 * @param recordId	the id of the record to retrieve
	 * @param auditDatesRecord	CBSSAuditDates object whose createdDate and modifiedDate properties will be set
	 * 			from the values read from the database table. If auditDatesRecord is null, then a new
	 * 			CBSSAuditDates object will be created and returned.
	 * @return	CBSSAuditDates object with createdDate and modifiedDate properties set from the values read
	 * 			from the database table. If auditDatesRecord is not null, then it will be updated and returned.
	 * 			Otherwise, a new CBSSAuditDates object will be created and returned.
	 */
	public CBSSAuditDates getAuditDates(String cbssTableName, long recordId, CBSSAuditDates auditDatesRecord);

}
