package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.cbs.CBSMessage;

/**
 * Data Access Object interface for the CBSMessage table.
 * 
 * @author Brad Pickle
 *
 */
public interface CBSMessageDAO {

	/**
	 * Get CBSMessages with the given statusId
	 * 
	 * @param statusId
	 *            get CBSMessages with this statusId
	 * @return CBSMessages with the given statusId
	 */
	List<CBSMessage> getCBSMessagesInStatus(int statusId);

	/**
	 * Get CBSMessage with the given id
	 * 
	 * @param id
	 *            id of the CBSMessage to get
	 * @return CBSMessage with given id
	 */
	CBSMessage get(long id);

	/**
	 * Update the CBSMessage row identified by cbsMessage.getId() with
	 * modifiable fields from cbsMessage.
	 * 
	 * @param cbsMessage
	 *            CBSMessage containing the id of the record to change and the
	 *            modifiable fields to update. The createdBy, createdDate,
	 *            modifiedBy and modifiedDate properties will be updated to
	 *            match the database state after the update.
	 */
	void update(CBSMessage cbsMessage);

	/**
	 * Insert a new CBSMessage row with the given cbsMessage.
	 * 
	 * @param cbsMessage
	 *            CBSMessage to create. The id, createdBy, createdDate,
	 *            modifiedBy and modifiedDate properties will be updated to
	 *            match the database state after the insert.
	 * @return long id of the new row
	 */
	long insert(CBSMessage cbsMessage);

}
