package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.BatchRunProcess;

/**
 * 
 * The DAO interface for Batch Run Process table.
 * 
 * Copyright HPE / VA
 * February 14, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
public interface BatchRunProcessDAO extends CBSSBaseDAO
{
    /**
     * Update the status of the specified BatchRunProcess object in the database.
     * 
     * @param batchRunProcess
     */
    public void updateStatus(final BatchRunProcess process);

    public long insert (BatchRunProcess brp);
    
    public void update (BatchRunProcess brp);
    
    public BatchRunProcess get (long id);
    
    public BatchRunProcess getByBatchRunId (int batchRunId);
    
    public List<BatchRunProcess> getBatchRunProcessesInStatus (final int statusId);
    
    public int updateStatus(final List<Long> batchRunProcessIdList, final int statusId);

}
