package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.apps.APSSiteStmt;

/**
 * Data Access Object interface for the APSSiteStmt table.
 * 
 * Copyright HPE / VA
 * January 18, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
public interface APSSiteStmtDAO extends CBSSBaseDAO
{

    /**
     * Get the existing Site Statements using Statement ID.
     * 
     * @param inIDs
     * @return
     * 
     */
    public List<APSSiteStmt> getExistingSiteStatements(final Long[] inIDs);

    /**
     * Batch update a list of Site Statements.
     * 
     * @param inStmts
     * @return
     * 
     */
    public int[] batchUpdate(final List<APSSiteStmt> inSiteStmts);
    
    /**
     * Get the List of annual statement sites (APSSiteStmt) for the given
     * apsStmtId Also loads the site patient.
     */
    public List<APSSiteStmt> getStmtSitesForStmt(long apsStmtId);

}
