package gov.va.cpss.dao;

import java.sql.Date;
import java.util.List;

import gov.va.cpss.model.apps.APSPatient;
import gov.va.cpss.model.apps.APSSite;

/**
 * Data Access Object interface for the APSSite table.
 * 
 * Copyright HPE / VA
 * October 20, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
public interface APSSiteDAO extends CBSSBaseDAO
{
	/**
	 * Delete the entry in the table associated with the specified received ID.
	 * 
	 * @param receivedId
	 */
	public void deleteByReceivedId(final long receivedId);

    /**
     * Delete the sites by the facility numbers.
     * 
     * @param facilityNumbers
     */
    public int[] deleteByFacilityNumbers(final List<String> facilityNumbers);

	/**
	 * Get the site by the id.
	 * 
	 * @param id
	 */
	public APSSite getById(final long id);

	/**
	 * Get a list of all site by the specified received id.
	 */
	public List<APSSite> getAllByAPSReceivedId(final long receivedId);

	/**
	 * Get a list of all site id by the specified list of received id.
	 */
	public List<Long> getAllIdByAPSReceivedId(final long receivedId);

	/**
     * Return the sites that have received payment files for the statement year.
     */
    public List<APSSite> getPaymentReceivedSites(final int statementYear, Date processDate);

    /**
     * Get the sites by the patients.
     * 
     * @param patients
     */
    public List<APSSite> getByPatients(final List<APSPatient> patients);
}
