package gov.va.cpss.controller;

import java.util.Base64;
//import java.util.Date;
import java.util.List;
//import org.apache.log4j.Logger;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import gov.va.cpss.jasper.PdfPatientStatementFactoryService;
import gov.va.cpss.model.cbs.CBSStmt;
import gov.va.cpss.service.CbsService;

/**
 * VBS REST Controller class.
 * 
 * Copyright HPE / DXC / VA
 * 
 * @author Unknown
 * @version 1.0.0
 * 
 */
@RestController
@SuppressWarnings("nls")
public class VBSRestController {

	//private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
	
	private PdfPatientStatementFactoryService pdfPatientStatementFactoryService;

	private CbsService cbsService;

	public PdfPatientStatementFactoryService getPdfPatientStatementFactoryService() {
		return this.pdfPatientStatementFactoryService;
	}

	public void setPdfPatientStatementFactoryService(
			PdfPatientStatementFactoryService inPdfPatientStatementFactoryService) {
		this.pdfPatientStatementFactoryService = inPdfPatientStatementFactoryService;
	}

	public CbsService getCbsService() {
		return this.cbsService;
	}

	public void setCbsService(CbsService inCbsService) {
		this.cbsService = inCbsService;
	}

	/**
	 * Retrieves list of statements for associated icn
	 * @param icn
	 * @return cbsStmt
	 * 			list of available statements as string array containing id and date
	 */
	@RequestMapping(method = RequestMethod.GET, value = "/vbs-webapp/vbsGetStmtList/{icn}")
	public String[] icnList(@PathVariable(value="icn") String icn) {
		long cbsId = getCbsService().getCbsAccountDAO().getByICN(icn).longValue();

		// Fix for Defect 616440
		// Yiping Yao - 11/15/2017, 01/03/2018
		List<CBSStmt> cbsStmtL = getCbsService().getStatements(cbsId);

		//List<CBSStmt> cbsStmtL = getCbsService().getCbsStmtDAO().getListOfStmntsById(cbsId);

		if (cbsStmtL == null || cbsStmtL.size() == 0)
		{
			return null;
		}

		String cbsStmt[] = new String[cbsStmtL.size()];
		//Retrieve only the id and date of each CBSStmt because CBSStmt
		//on vbs side only holds id and date
		for(int i = 0; i<cbsStmtL.size(); i++){
			cbsStmt[i]= cbsStmtL.get(i).getId() + " " + cbsStmtL.get(i).getStatementDate();
		}

		return cbsStmt;
	}
	
	/**
	 * Returns encoded generated pdf
	 * @param id
	 * 			id of selected statement
	 * @return encoded pdf
	 */
	@RequestMapping(method = RequestMethod.GET, value = "/vbs-webapp/vbsGetPdf/{id}")
	public byte[] stmntSelect(@PathVariable(value="id") int id) {
		byte[] pdf=	this.pdfPatientStatementFactoryService.generateStatementPdfStream(id);
		byte[] encodedBytes = Base64.getEncoder().encode(pdf);
		return encodedBytes;
	}
}
